/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.api.cellar.booze;

import growthcraft.api.cellar.booze.BoozeEffect;
import growthcraft.api.cellar.booze.BoozeEntry;
import growthcraft.api.cellar.booze.IBoozeRegistry;
import growthcraft.api.cellar.booze.IModifierFunction;
import growthcraft.api.core.fluids.FluidTag;
import growthcraft.api.core.fluids.FluidUtils;
import growthcraft.api.core.log.ILogger;
import growthcraft.api.core.log.NullLogger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class BoozeRegistry
implements IBoozeRegistry {
    private ILogger logger = NullLogger.INSTANCE;
    private Map<Fluid, BoozeEntry> boozeMap = new HashMap<Fluid, BoozeEntry>();
    private Map<FluidTag, IModifierFunction> tagModifierFunctions = new HashMap<FluidTag, IModifierFunction>();

    @Override
    public void setLogger(@Nonnull ILogger l) {
        this.logger = l;
    }

    @Override
    public IModifierFunction getModifierFunction(@Nullable FluidTag tag) {
        return this.tagModifierFunctions.get(tag);
    }

    @Override
    public void setModifierFunction(@Nonnull FluidTag tag, IModifierFunction func) {
        this.tagModifierFunctions.put(tag, func);
    }

    @Override
    public Collection<BoozeEntry> getBoozeEntries() {
        return this.boozeMap.values();
    }

    private void ensureFluidIsValid(Fluid fluid) {
        if (!FluidUtils.doesFluidExist(fluid)) {
            throw new IllegalArgumentException("[Growthcraft|Cellar] The fluid being registered as a Booze is not registered to the FluidRegistry.");
        }
    }

    @Override
    @Nullable
    public BoozeEntry getBoozeEntry(Fluid fluid) {
        if (fluid == null) {
            return null;
        }
        return this.boozeMap.get(fluid);
    }

    @Override
    @Nonnull
    public BoozeEntry fetchBoozeEntry(Fluid fluid) {
        BoozeEntry entry = this.getBoozeEntry(fluid);
        if (entry == null) {
            throw new IllegalArgumentException("[Growthcraft|Cellar] The fluid being tagged does not have a valid booze entry.");
        }
        return entry;
    }

    @Override
    @Nullable
    public BoozeEffect getEffect(Fluid fluid) {
        BoozeEntry entry = this.getBoozeEntry(fluid);
        return entry != null ? entry.getEffect() : null;
    }

    @Override
    public boolean isFluidBooze(Fluid f) {
        if (f == null) {
            return false;
        }
        return this.getBoozeEntry(f) != null;
    }

    @Override
    public boolean isFluidBooze(FluidStack fluidStack) {
        if (fluidStack == null) {
            return false;
        }
        return this.isFluidBooze(fluidStack.getFluid());
    }

    protected void registerBooze(@Nonnull Fluid fluid, @Nonnull BoozeEntry entry) {
        this.boozeMap.put(fluid, entry);
    }

    @Override
    public void registerBooze(@Nonnull Fluid fluid) {
        this.ensureFluidIsValid(fluid);
        if (this.isFluidBooze(fluid)) {
            throw new IllegalArgumentException("[Growthcraft|Cellar] The fluid being registered as a Booze is already registered to the CellarRegistry.");
        }
        this.logger.debug("Registering booze %s", fluid.getName());
        this.registerBooze(fluid, new BoozeEntry(fluid));
    }
}

