/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.api.cellar.brewing.user;

import growthcraft.api.cellar.CellarRegistry;
import growthcraft.api.cellar.brewing.user.UserBrewingRecipe;
import growthcraft.api.cellar.brewing.user.UserBrewingRecipes;
import growthcraft.api.cellar.common.Residue;
import growthcraft.api.core.definition.IMultiItemStacks;
import growthcraft.api.core.schema.FluidStackSchema;
import growthcraft.api.core.schema.ItemKeySchema;
import growthcraft.api.core.schema.ResidueSchema;
import growthcraft.api.core.user.AbstractUserJSONConfig;
import java.io.BufferedReader;
import java.io.Reader;
import net.minecraftforge.fluids.FluidStack;

public class UserBrewingRecipesConfig
extends AbstractUserJSONConfig {
    private final UserBrewingRecipes defaultRecipes = new UserBrewingRecipes();
    private UserBrewingRecipes recipes;

    public void addDefault(UserBrewingRecipe recipe) {
        this.defaultRecipes.data.add(recipe);
        this.logger.debug("Added new default brewing recipe={%s}", recipe);
    }

    public void addDefault(Object stack, FluidStack inp, FluidStack out, Residue residue, int time) {
        for (ItemKeySchema itemKey : ItemKeySchema.createMulti(stack)) {
            this.addDefault(new UserBrewingRecipe(itemKey, new FluidStackSchema(inp), new FluidStackSchema(out), residue == null ? null : new ResidueSchema(residue), time));
        }
    }

    @Override
    protected String getDefault() {
        return this.gson.toJson((Object)this.defaultRecipes);
    }

    @Override
    protected void loadFromBuffer(BufferedReader reader) throws IllegalStateException {
        this.recipes = (UserBrewingRecipes)this.gson.fromJson((Reader)reader, UserBrewingRecipes.class);
    }

    private void addBrewingRecipe(UserBrewingRecipe recipe) {
        if (recipe == null) {
            this.logger.error("Invalid recipe", new Object[0]);
            return;
        }
        if (recipe.item == null || recipe.item.isInvalid()) {
            this.logger.error("Invalid item for recipe {%s}", recipe);
            return;
        }
        if (recipe.input_fluid == null || recipe.input_fluid.isInvalid()) {
            this.logger.error("Invalid input_fluid {%s}", recipe);
            return;
        }
        if (recipe.output_fluid == null || recipe.output_fluid.isInvalid()) {
            this.logger.error("Invalid output_fluid {%s}", recipe);
            return;
        }
        Residue residue = null;
        if (recipe.residue != null && (residue = recipe.residue.asResidue()) == null) {
            this.logger.error("Not a valid residue found for {%s}", recipe);
            return;
        }
        FluidStack inputFluidStack = recipe.input_fluid.asFluidStack();
        FluidStack outputFluidStack = recipe.output_fluid.asFluidStack();
        this.logger.debug("Adding user brewing recipe {%s}", recipe);
        for (IMultiItemStacks item : recipe.item.getMultiItemStacks()) {
            CellarRegistry.instance().brewing().addRecipe(inputFluidStack, item, outputFluidStack, recipe.time, residue);
        }
    }

    @Override
    public void postInit() {
        if (this.recipes != null) {
            if (this.recipes.data != null) {
                this.logger.debug("Adding %d user brewing recipes.", this.recipes.data.size());
                for (UserBrewingRecipe recipe : this.recipes.data) {
                    this.addBrewingRecipe(recipe);
                }
            } else {
                this.logger.error("Recipes data is invalid!", new Object[0]);
            }
        }
    }
}

