/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.api.cellar.culturing;

import growthcraft.api.cellar.culturing.CultureRecipe;
import growthcraft.api.cellar.culturing.ICultureRecipe;
import growthcraft.api.cellar.culturing.ICulturingRegistry;
import growthcraft.api.core.log.ILogger;
import growthcraft.api.core.log.NullLogger;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class CulturingRegistry
implements ICulturingRegistry {
    private List<ICultureRecipe> recipes = new ArrayList<ICultureRecipe>();
    private ILogger logger = NullLogger.INSTANCE;

    @Override
    public void setLogger(@Nonnull ILogger l) {
        this.logger = l;
    }

    @Override
    public void addRecipe(@Nonnull ICultureRecipe recipe) {
        this.recipes.add(recipe);
        this.logger.debug("Adding new Culturing Recipe, {%s}.", recipe);
    }

    @Override
    public void addRecipe(@Nonnull FluidStack fluidStack, @Nonnull ItemStack itemStack, float requiredHeat, int time) {
        this.addRecipe(new CultureRecipe(fluidStack, itemStack, requiredHeat, time));
    }

    @Override
    public ICultureRecipe findRecipe(@Nullable FluidStack fluid, float heat) {
        for (ICultureRecipe recipe : this.recipes) {
            if (!recipe.matchesRecipe(fluid, heat)) continue;
            return recipe;
        }
        return null;
    }
}

