/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.api.core.description;

import growthcraft.api.core.description.IDescribable;
import growthcraft.api.core.i18n.GrcI18n;
import java.util.List;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumChatFormatting;

public class Describer {
    private Describer() {
    }

    public static void getDescription(List<String> list, Object obj) {
        if (obj instanceof IDescribable) {
            ((IDescribable)obj).getDescription(list);
        }
    }

    public static void getPotionEffectDescription(List<String> list, PotionEffect pe) {
        if (pe == null) {
            return;
        }
        String s = GrcI18n.translate(pe.func_76453_d()).trim();
        Potion potion = Potion.field_76425_a[pe.func_76456_a()];
        if (potion != null && potion.func_76398_f()) {
            s = EnumChatFormatting.RED + s;
        }
        if (pe.func_76458_c() > 0) {
            s = s + " " + GrcI18n.translate("potion.potency." + pe.func_76458_c()).trim();
        }
        if (pe.func_76459_b() > 20) {
            s = s + "" + EnumChatFormatting.GRAY + " (" + Potion.func_76389_a((PotionEffect)pe) + ")";
        }
        list.add(s);
    }

    public static void addAllPrefixed(String prefix, List<String> dest, List<String> src) {
        for (String str : src) {
            dest.add(prefix + str);
        }
    }

    public static void addAllIndented(List<String> dest, List<String> src) {
        Describer.addAllPrefixed("  ", dest, src);
    }

    public static void compactDescription(String head, List<String> dest, List<String> src) {
        if (src.size() > 0) {
            if (src.size() == 1) {
                String line = src.get(0);
                dest.add(head + " " + line);
            } else {
                dest.add(head);
                Describer.addAllIndented(dest, src);
            }
        }
    }
}

