/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.api.core.item;

import growthcraft.api.core.definition.IItemStackListProvider;
import growthcraft.api.core.definition.IMultiFluidStacks;
import growthcraft.api.core.definition.IMultiItemStacks;
import growthcraft.api.core.item.ItemTest;
import growthcraft.api.core.item.MultiItemStacks;
import growthcraft.api.core.item.OreItemStacks;
import growthcraft.api.core.util.MultiStacksUtil;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class CombinedMultiItemStacks
implements IMultiItemStacks {
    public int stackSize;
    private List<IItemStackListProvider> itemStacks = new ArrayList<IItemStackListProvider>();

    public CombinedMultiItemStacks(int amount, Object ... items) {
        for (Object in : items) {
            if (in instanceof ItemStack) {
                this.itemStacks.add(new MultiItemStacks(((ItemStack)in).func_77946_l()));
                continue;
            }
            if (in instanceof Item) {
                this.itemStacks.add(new MultiItemStacks(new ItemStack((Item)in)));
                continue;
            }
            if (in instanceof Block) {
                this.itemStacks.add(new MultiItemStacks(new ItemStack((Block)in)));
                continue;
            }
            if (in instanceof String) {
                this.itemStacks.add(new OreItemStacks((String)in));
                continue;
            }
            if (in instanceof IMultiItemStacks) {
                this.itemStacks.add((IMultiItemStacks)in);
                continue;
            }
            if (in instanceof FluidStack) {
                this.itemStacks.add(MultiStacksUtil.toMultiFluidStacks(in));
                continue;
            }
            if (in instanceof IMultiFluidStacks) {
                this.itemStacks.add((IMultiFluidStacks)in);
                continue;
            }
            String ret = "Invalid MultiOreItemStacks: ";
            for (Object tmp : items) {
                ret = ret + tmp + ", ";
            }
            throw new RuntimeException(ret);
        }
        this.stackSize = amount;
    }

    public CombinedMultiItemStacks(Object ... items) {
        this(1, items);
    }

    @Override
    public int getStackSize() {
        return this.stackSize;
    }

    public List<ItemStack> getRawItemStacks() {
        ArrayList<ItemStack> output = new ArrayList<ItemStack>();
        for (IItemStackListProvider itemList : this.itemStacks) {
            output.addAll(itemList.getItemStacks());
        }
        return output;
    }

    @Override
    public boolean isEmpty() {
        return this.getRawItemStacks().isEmpty();
    }

    @Override
    public List<ItemStack> getItemStacks() {
        List<ItemStack> items = this.getRawItemStacks();
        LinkedHashSet<ItemStack> result = new LinkedHashSet<ItemStack>();
        for (ItemStack stack : items) {
            ItemStack newStack = stack.func_77946_l();
            if (newStack.field_77994_a <= 0) {
                newStack.field_77994_a = 1;
            }
            newStack.field_77994_a *= this.stackSize;
            result.add(newStack);
        }
        return new ArrayList<ItemStack>(result);
    }

    @Override
    public boolean containsItemStack(@Nullable ItemStack stack) {
        if (!ItemTest.isValid(stack)) {
            return false;
        }
        for (ItemStack content : this.getItemStacks()) {
            if (!content.func_77969_a(stack)) continue;
            return true;
        }
        return false;
    }
}

