/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.api.core.item;

import growthcraft.api.core.definition.IMultiItemStacks;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;

public class ItemTest {
    private ItemTest() {
    }

    public static boolean isValid(@Nonnull ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (stack.func_77973_b() == null) {
            return false;
        }
        return stack.field_77994_a > 0;
    }

    public static boolean itemMatches(@Nullable IMultiItemStacks expected, @Nullable ItemStack actual) {
        if (expected == null || expected.isEmpty()) {
            return actual == null;
        }
        if (actual != null) {
            return expected.containsItemStack(actual);
        }
        return false;
    }

    public static boolean itemMatches(@Nullable ItemStack expected, @Nullable ItemStack actual) {
        if (expected == null) {
            return actual == null;
        }
        if (actual != null) {
            if (expected.func_77960_j() == Short.MAX_VALUE) {
                return expected.func_77973_b() == actual.func_77973_b();
            }
            return expected.func_77969_a(actual);
        }
        return false;
    }

    public static boolean areStacksEqual(@Nullable IMultiItemStacks expected, @Nullable ItemStack actual) {
        if (!ItemTest.itemMatches(expected, actual)) {
            return false;
        }
        return actual.field_77994_a == expected.getStackSize();
    }

    public static boolean areStacksEqual(@Nullable ItemStack expected, @Nullable ItemStack actual) {
        if (!ItemTest.itemMatches(expected, actual)) {
            return false;
        }
        return actual.field_77994_a == expected.field_77994_a;
    }

    public static boolean hasEnough(@Nullable IMultiItemStacks expected, @Nullable ItemStack actual) {
        if (!ItemTest.itemMatches(expected, actual)) {
            return false;
        }
        return actual.field_77994_a >= expected.getStackSize();
    }

    public static boolean hasEnough(@Nullable ItemStack expected, @Nullable ItemStack actual) {
        if (!ItemTest.itemMatches(expected, actual)) {
            return false;
        }
        return actual.field_77994_a >= expected.field_77994_a;
    }

    public static boolean isValidAndExpected(@Nonnull List expectedItems, @Nonnull List<ItemStack> givenItems) {
        if (expectedItems.size() != givenItems.size()) {
            return false;
        }
        for (int i = 0; i < expectedItems.size(); ++i) {
            Object expected = expectedItems.get(i);
            ItemStack actual = givenItems.get(i);
            if (expected != null) {
                if (!ItemTest.isValid(actual)) {
                    return false;
                }
                if (expected instanceof ItemStack) {
                    if (((ItemStack)expected).func_77969_a(actual)) continue;
                    return false;
                }
                if (expected instanceof IMultiItemStacks) {
                    if (((IMultiItemStacks)expected).containsItemStack(actual)) continue;
                    return false;
                }
                return false;
            }
            if (actual == null) continue;
            return false;
        }
        return true;
    }

    public static boolean containsExpectedItemsUnordered(@Nonnull List expectedItems, @Nonnull List<ItemStack> givenItems) {
        boolean[] usedSlots = new boolean[givenItems.size()];
        for (Object expectedStack : expectedItems) {
            boolean found = false;
            for (int index = 0; index < usedSlots.length; ++index) {
                if (usedSlots[index]) continue;
                if (expectedStack instanceof IMultiItemStacks) {
                    found = ItemTest.itemMatches((IMultiItemStacks)expectedStack, givenItems.get(index));
                } else if (expectedStack instanceof ItemStack) {
                    found = ItemTest.itemMatches((ItemStack)expectedStack, givenItems.get(index));
                } else if (expectedStack == null) {
                    boolean bl = found = givenItems.get(index) == null;
                }
                if (!found) continue;
                usedSlots[index] = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }
}

