/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.api.core.nbt;

import java.util.HashMap;
import java.util.Map;

public enum NBTType {
    END(0),
    BYTE(1),
    SHORT(2),
    INT(3),
    LONG(4),
    FLOAT(5),
    DOUBLE(6),
    BYTE_ARRAY(7),
    STRING(8),
    LIST(9),
    COMPOUND(10),
    INT_ARRAY(11);

    public static final Map<Integer, NBTType> MAPPING;
    public final int id;

    private NBTType(int i) {
        this.id = i;
    }

    public static NBTType byId(int id) {
        return MAPPING.get(id);
    }

    static {
        MAPPING = new HashMap<Integer, NBTType>();
        for (NBTType type : NBTType.values()) {
            MAPPING.put(type.id, type);
        }
    }
}

