/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.api.core.schema;

import cpw.mods.fml.common.registry.GameRegistry;
import growthcraft.api.core.definition.IItemStackFactory;
import growthcraft.api.core.definition.IItemStackListProvider;
import growthcraft.api.core.definition.IMultiItemStacks;
import growthcraft.api.core.item.MultiItemStacks;
import growthcraft.api.core.schema.ICommentable;
import growthcraft.api.core.schema.IValidatable;
import growthcraft.api.core.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ItemStackSchema
implements IItemStackFactory,
IItemStackListProvider,
IValidatable,
ICommentable {
    public String comment;
    public String mod_id;
    public String name;
    public int amount;
    public int meta;

    public ItemStackSchema(@Nonnull String mid, @Nonnull String nm, int amt, int mt) {
        this.mod_id = mid;
        this.name = nm;
        this.amount = amt;
        this.meta = mt;
        this.comment = "";
    }

    public ItemStackSchema(@Nonnull ItemStack stack) {
        GameRegistry.UniqueIdentifier uuid = GameRegistry.findUniqueIdentifierFor((Item)stack.func_77973_b());
        this.mod_id = uuid.modId;
        this.name = uuid.name;
        this.amount = stack.field_77994_a;
        this.meta = stack.func_77960_j();
        this.comment = stack.func_82833_r();
    }

    public ItemStackSchema() {
        this.amount = 1;
        this.meta = Short.MAX_VALUE;
        this.comment = "";
    }

    @Override
    public void setComment(String comm) {
        this.comment = comm;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    public Item getItem() {
        if (this.mod_id == null || this.name == null) {
            return null;
        }
        return GameRegistry.findItem((String)this.mod_id, (String)this.name);
    }

    @Override
    public ItemStack asStack(int a) {
        Item item = this.getItem();
        if (item == null) {
            return null;
        }
        return new ItemStack(item, a, this.meta < 0 ? Short.MAX_VALUE : this.meta);
    }

    @Override
    public ItemStack asStack() {
        return this.asStack(this.amount);
    }

    @Override
    public List<ItemStack> getItemStacks() {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        ItemStack stack = this.asStack();
        if (stack != null) {
            result.add(stack);
        }
        return result;
    }

    public List<IMultiItemStacks> getMultiItemStacks() {
        ArrayList<IMultiItemStacks> result = new ArrayList<IMultiItemStacks>();
        ItemStack stack = this.asStack();
        if (stack != null) {
            result.add(new MultiItemStacks(stack));
        }
        return result;
    }

    public String toString() {
        return String.format("Schema<ItemStack>(comment: '%s', mod_id: '%s', name: '%s', meta: %d, amount: %d)", StringUtils.inspect(this.comment), this.mod_id, this.name, this.meta, this.amount);
    }

    @Override
    public boolean isValid() {
        return this.asStack() != null;
    }

    @Override
    public boolean isInvalid() {
        return !this.isValid();
    }
}

