/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.api.core.util;

import growthcraft.api.core.util.TagParser;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;

public class BiomeUtils {
    private BiomeUtils() {
    }

    public static BiomeDictionary.Type fetchBiomeType(String name) throws BiomeTypeNotFound {
        String upcasedName = name.toUpperCase();
        for (BiomeDictionary.Type type : BiomeDictionary.Type.values()) {
            if (!type.name().equals(upcasedName)) continue;
            return type;
        }
        throw new BiomeTypeNotFound("Biome type '" + name + "' not found.");
    }

    public static boolean testBiomeTypeTags(BiomeGenBase biome, TagParser.Tag[] tags) {
        if (tags.length == 0) {
            return false;
        }
        boolean hasMatching = false;
        for (TagParser.Tag tag : tags) {
            try {
                boolean res = BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeUtils.fetchBiomeType(tag.value));
                if (tag.exclude && res) {
                    return false;
                }
                if (tag.must && !res) {
                    return false;
                }
                if (!res) continue;
                hasMatching = true;
            }
            catch (BiomeTypeNotFound ex) {
                ex.printStackTrace();
                return false;
            }
        }
        return hasMatching;
    }

    public static boolean testBiomeTypeTagsTable(BiomeGenBase biome, TagParser.Tag[][] tagTable) {
        for (TagParser.Tag[] row : tagTable) {
            if (!BiomeUtils.testBiomeTypeTags(biome, row)) continue;
            return true;
        }
        return false;
    }

    public static boolean testBiomeIdTags(String biomeId, TagParser.Tag[] tags) {
        for (TagParser.Tag tag : tags) {
            if (!tag.value.equals(biomeId)) continue;
            return true;
        }
        return false;
    }

    public static class BiomeTypeNotFound
    extends Exception {
        public static final long serialVersionUID = 1L;

        public BiomeTypeNotFound(String msg) {
            super(msg);
        }

        public BiomeTypeNotFound() {
        }
    }
}

