/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.api.core.util;

import net.minecraftforge.common.util.ForgeDirection;

public class Point3 {
    public final int x;
    public final int y;
    public final int z;

    public Point3(int px, int py, int pz) {
        this.x = px;
        this.y = py;
        this.z = pz;
    }

    public Point3(Point3 point) {
        this(point.x, point.y, point.z);
    }

    public Point3(ForgeDirection dir) {
        this(dir.offsetX, dir.offsetY, dir.offsetZ);
    }

    public Point3() {
        this(0, 0, 0);
    }

    public Point3 dup() {
        return new Point3(this.x, this.y, this.z);
    }

    public Point3 identity() {
        return this.dup();
    }

    public Point3 invert() {
        return new Point3(-this.x, -this.y, -this.z);
    }

    public Point3 add(int px, int py, int pz) {
        return new Point3(this.x + px, this.y + py, this.z + pz);
    }

    public Point3 add(Point3 point) {
        return this.add(point.x, point.y, point.z);
    }

    public Point3 add(ForgeDirection dir) {
        return this.add(dir.offsetX, dir.offsetY, dir.offsetZ);
    }

    public Point3 sub(int px, int py, int pz) {
        return new Point3(this.x - px, this.y - py, this.z - pz);
    }

    public Point3 sub(Point3 point) {
        return this.sub(point.x, point.y, point.z);
    }

    public Point3 sub(ForgeDirection dir) {
        return this.sub(dir.offsetX, dir.offsetY, dir.offsetZ);
    }

    public Point3 mul(int px, int py, int pz) {
        return new Point3(this.x * px, this.y * py, this.z * pz);
    }

    public Point3 mul(float px, float py, float pz) {
        return new Point3(Math.round((float)this.x * px), Math.round((float)this.y * py), Math.round((float)this.z * pz));
    }

    public Point3 mul(Point3 point) {
        return this.mul(point.x, point.y, point.z);
    }

    public Point3 mul(ForgeDirection dir) {
        return this.mul(dir.offsetX, dir.offsetY, dir.offsetZ);
    }

    public String toString() {
        return String.format("(%d, %d, %d)", this.x, this.y, this.z);
    }

    public int[] toArray() {
        return new int[]{this.x, this.y, this.z};
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.x;
        result = 31 * result + this.y;
        result = 31 * result + this.z;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Point3) {
            Point3 other = (Point3)obj;
            return this.x == other.x && this.y == other.y && this.z == other.z;
        }
        return false;
    }
}

