/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.api.fishtrap.user;

import growthcraft.api.core.user.AbstractUserJSONConfig;
import growthcraft.api.fishtrap.FishTrapRegistry;
import growthcraft.api.fishtrap.user.UserCatchGroupEntries;
import growthcraft.api.fishtrap.user.UserCatchGroupEntry;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.Map;

public class UserCatchGroupConfig
extends AbstractUserJSONConfig {
    private final UserCatchGroupEntries defaultEntries = new UserCatchGroupEntries();
    private UserCatchGroupEntries entries;

    public void addDefault(String group, int weight, String comment) {
        UserCatchGroupEntry entry = new UserCatchGroupEntry(weight);
        entry.setComment(comment);
        this.defaultEntries.data.put(group, entry);
    }

    @Override
    protected String getDefault() {
        return this.gson.toJson((Object)this.defaultEntries);
    }

    @Override
    protected void loadFromBuffer(BufferedReader buff) throws IllegalStateException {
        this.entries = (UserCatchGroupEntries)this.gson.fromJson((Reader)buff, UserCatchGroupEntries.class);
    }

    private void addCatchGroupEntry(String name, UserCatchGroupEntry entry) {
        if (entry == null) {
            this.logger.error("Invalid Entry", new Object[0]);
            return;
        }
        if (entry.weight <= 0) {
            this.logger.error("Invalid weight for entry {%s}", entry);
            return;
        }
        this.logger.debug("Adding Catch Group %s", name);
        FishTrapRegistry.instance().addCatchGroup(name, entry.weight);
    }

    @Override
    public void postInit() {
        if (this.entries != null) {
            if (this.entries.data != null) {
                this.logger.debug("Adding %d user catch groups.", this.entries.data.size());
                for (Map.Entry<String, UserCatchGroupEntry> pair : this.entries.data.entrySet()) {
                    this.addCatchGroupEntry(pair.getKey(), pair.getValue());
                }
            } else {
                this.logger.error("Config contains invalid data.", new Object[0]);
            }
        }
    }
}

