/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.apples.common.block;

import growthcraft.apples.GrowthCraftApples;
import growthcraft.apples.common.world.WorldGenAppleTree;
import growthcraft.core.GrowthCraftCore;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.world.World;
import net.minecraftforge.event.terraingen.TerrainGen;

public class BlockAppleSapling
extends BlockBush
implements IGrowable {
    private final int growth;

    public BlockAppleSapling() {
        super(Material.field_151585_k);
        this.growth = GrowthCraftApples.getConfig().appleSaplingGrowthRate;
        this.func_149711_c(0.0f);
        this.func_149672_a(field_149779_h);
        this.func_149663_c("grc.appleSapling");
        this.func_149675_a(true);
        this.func_149647_a(GrowthCraftCore.creativeTab);
        this.func_149658_d("grcapples:apple_sapling");
        float f = 0.4f;
        this.func_149676_a(0.099999994f, 0.0f, 0.099999994f, 0.9f, 0.8f, 0.9f);
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        if (!world.field_72995_K) {
            super.func_149674_a(world, x, y, z, random);
            if (world.func_72957_l(x, y + 1, z) >= 9 && random.nextInt(this.growth) == 0) {
                this.markOrGrowMarked(world, x, y, z, random);
            }
        }
    }

    public void markOrGrowMarked(World world, int x, int y, int z, Random random) {
        int meta = world.func_72805_g(x, y, z);
        if ((meta & 8) == 0) {
            world.func_72921_c(x, y, z, meta | 8, 4);
        } else {
            this.growTree(world, x, y, z, random);
        }
    }

    public void growTree(World world, int x, int y, int z, Random random) {
        if (!TerrainGen.saplingGrowTree((World)world, (Random)random, (int)x, (int)y, (int)z)) {
            return;
        }
        int meta = world.func_72805_g(x, y, z) & 3;
        WorldGenAppleTree generator = new WorldGenAppleTree(true);
        world.func_147468_f(x, y, z);
        if (!generator.func_76484_a(world, random, x, y, z)) {
            world.func_147465_d(x, y, z, (Block)this, meta, 7);
        }
    }

    public boolean func_149851_a(World world, int x, int y, int z, boolean isClient) {
        return (world.func_72805_g(x, y, z) & 8) == 0;
    }

    public boolean func_149852_a(World world, Random random, int x, int y, int z) {
        return true;
    }

    public void func_149853_b(World world, Random random, int x, int y, int z) {
        if ((double)random.nextFloat() < 0.45) {
            this.growTree(world, x, y, z, random);
        }
    }
}

