/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.bamboo;

import cpw.mods.fml.common.IFuelHandler;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.VillagerRegistry;
import growthcraft.api.core.log.GrcLogger;
import growthcraft.api.core.log.ILogger;
import growthcraft.api.core.module.ModuleContainer;
import growthcraft.bamboo.GrcBambooConfig;
import growthcraft.bamboo.common.CommonProxy;
import growthcraft.bamboo.common.entity.EntityBambooRaft;
import growthcraft.bamboo.common.village.ComponentVillageBambooYard;
import growthcraft.bamboo.common.village.VillageHandlerBamboo;
import growthcraft.bamboo.common.world.BiomeGenBamboo;
import growthcraft.bamboo.common.world.WorldGeneratorBamboo;
import growthcraft.bamboo.creativetab.CreativeTabsGrowthcraftBamboo;
import growthcraft.bamboo.event.BonemealEventBamboo;
import growthcraft.bamboo.handler.BambooFuelHandler;
import growthcraft.bamboo.init.GrcBambooBlocks;
import growthcraft.bamboo.init.GrcBambooItems;
import growthcraft.bamboo.integration.ForestryModule;
import growthcraft.bamboo.integration.MFRModule;
import growthcraft.bamboo.integration.ThaumcraftModule;
import growthcraft.core.util.MapGenHelper;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;

@Mod(modid="Growthcraft|Bamboo", name="Growthcraft Bamboo", version="1.7.10-2.7.2", dependencies="required-after:Growthcraft")
public class GrowthCraftBamboo {
    public static final String MOD_ID = "Growthcraft|Bamboo";
    public static final String MOD_NAME = "Growthcraft Bamboo";
    public static final String MOD_VERSION = "1.7.10-2.7.2";
    @Mod.Instance(value="Growthcraft|Bamboo")
    public static GrowthCraftBamboo instance;
    public static CreativeTabs creativeTab;
    public static final GrcBambooBlocks blocks;
    public static final GrcBambooItems items;
    public static BiomeGenBase bambooBiome;
    private final ILogger logger = new GrcLogger("Growthcraft|Bamboo");
    private final GrcBambooConfig config = new GrcBambooConfig();
    private final ModuleContainer modules = new ModuleContainer();

    public static GrcBambooConfig getConfig() {
        return GrowthCraftBamboo.instance.config;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.config.setLogger(this.logger);
        this.config.load(event.getModConfigurationDirectory(), "growthcraft/bamboo.conf");
        this.modules.add(blocks);
        this.modules.add(items);
        if (this.config.enableForestryIntegration) {
            this.modules.add(new ForestryModule());
        }
        if (this.config.enableMFRIntegration) {
            this.modules.add(new MFRModule());
        }
        if (this.config.enableThaumcraftIntegration) {
            this.modules.add(new ThaumcraftModule());
        }
        this.modules.add(CommonProxy.instance);
        if (this.config.debugEnabled) {
            this.modules.setLogger(this.logger);
        }
        this.modules.freeze();
        creativeTab = new CreativeTabsGrowthcraftBamboo("creative_tab_grcbamboo");
        this.modules.preInit();
        if (this.config.generateBambooBiome) {
            bambooBiome = new BiomeGenBamboo(this.config.bambooBiomeID).func_76739_b(353825).func_76735_a("BambooForest").func_76733_a(5159473).func_76732_a(0.7f, 0.8f);
        }
        this.register();
    }

    private void register() {
        this.modules.register();
        if (this.config.generateBambooBiome) {
            BiomeManager.addSpawnBiome((BiomeGenBase)bambooBiome);
            BiomeDictionary.registerBiomeType((BiomeGenBase)bambooBiome, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.DENSE, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.FOREST});
        }
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGeneratorBamboo(), (int)0);
        EntityRegistry.registerModEntity(EntityBambooRaft.class, (String)"bambooRaft", (int)1, (Object)this, (int)80, (int)3, (boolean)true);
        GameRegistry.addShapedRecipe((ItemStack)GrowthCraftBamboo.blocks.bambooWall.asStack(6), (Object[])new Object[]{"###", "###", Character.valueOf('#'), GrowthCraftBamboo.blocks.bambooBlock.getBlock()});
        GameRegistry.addShapedRecipe((ItemStack)GrowthCraftBamboo.blocks.bambooStairs.asStack(4), (Object[])new Object[]{"#  ", "## ", "###", Character.valueOf('#'), GrowthCraftBamboo.blocks.bambooBlock.getBlock()});
        GameRegistry.addShapedRecipe((ItemStack)GrowthCraftBamboo.blocks.bambooSingleSlab.asStack(6), (Object[])new Object[]{"###", Character.valueOf('#'), GrowthCraftBamboo.blocks.bambooBlock.getBlock()});
        GameRegistry.addShapedRecipe((ItemStack)GrowthCraftBamboo.items.bambooDoorItem.asStack(), (Object[])new Object[]{"##", "##", "##", Character.valueOf('#'), GrowthCraftBamboo.blocks.bambooBlock.getBlock()});
        GameRegistry.addShapedRecipe((ItemStack)GrowthCraftBamboo.items.bambooRaft.asStack(), (Object[])new Object[]{"A A", "AAA", Character.valueOf('A'), GrowthCraftBamboo.blocks.bambooBlock.getBlock()});
        GameRegistry.addShapedRecipe((ItemStack)GrowthCraftBamboo.blocks.bambooBlock.asStack(), (Object[])new Object[]{"A", "A", Character.valueOf('A'), GrowthCraftBamboo.blocks.bambooSingleSlab.getBlock()});
        GameRegistry.addShapedRecipe((ItemStack)GrowthCraftBamboo.blocks.bambooBlock.asStack(), (Object[])new Object[]{"AA", "AA", Character.valueOf('A'), GrowthCraftBamboo.items.bamboo.getItem()});
        GameRegistry.addShapedRecipe((ItemStack)GrowthCraftBamboo.blocks.bambooFence.asStack(3), (Object[])new Object[]{"AAA", "AAA", Character.valueOf('A'), GrowthCraftBamboo.items.bamboo.getItem()});
        GameRegistry.addShapedRecipe((ItemStack)GrowthCraftBamboo.blocks.bambooFenceGate.asStack(), (Object[])new Object[]{"ABA", "ABA", Character.valueOf('A'), GrowthCraftBamboo.items.bamboo.getItem(), Character.valueOf('B'), GrowthCraftBamboo.blocks.bambooBlock.getBlock()});
        GameRegistry.addShapedRecipe((ItemStack)GrowthCraftBamboo.blocks.bambooScaffold.asStack(16), (Object[])new Object[]{"BBB", " A ", "A A", Character.valueOf('A'), GrowthCraftBamboo.items.bamboo.getItem(), Character.valueOf('B'), GrowthCraftBamboo.blocks.bambooBlock.getBlock()});
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Blocks.field_150478_aa, 2), new Object[]{"A", "B", Character.valueOf('A'), GrowthCraftBamboo.items.bambooCoal.getItem(), Character.valueOf('B'), "stickWood"}));
        MapGenHelper.registerVillageStructure(ComponentVillageBambooYard.class, "grc.bambooyard");
        this.registerOres();
        GameRegistry.registerFuelHandler((IFuelHandler)new BambooFuelHandler());
        GameRegistry.addSmelting(GrowthCraftBamboo.items.bamboo.getItem(), (ItemStack)GrowthCraftBamboo.items.bambooCoal.asStack(), (float)0.075f);
    }

    public void registerOres() {
        OreDictionary.registerOre((String)"stickWood", GrowthCraftBamboo.items.bamboo.getItem());
        OreDictionary.registerOre((String)"woodStick", GrowthCraftBamboo.items.bamboo.getItem());
        OreDictionary.registerOre((String)"plankWood", (Block)GrowthCraftBamboo.blocks.bambooBlock.getBlock());
        OreDictionary.registerOre((String)"woodPlank", (Block)GrowthCraftBamboo.blocks.bambooBlock.getBlock());
        OreDictionary.registerOre((String)"slabWood", (Block)GrowthCraftBamboo.blocks.bambooSingleSlab.getBlock());
        OreDictionary.registerOre((String)"woodSlab", (Block)GrowthCraftBamboo.blocks.bambooSingleSlab.getBlock());
        OreDictionary.registerOre((String)"stairWood", GrowthCraftBamboo.blocks.bambooStairs.getBlock());
        OreDictionary.registerOre((String)"woodStair", GrowthCraftBamboo.blocks.bambooStairs.getBlock());
        OreDictionary.registerOre((String)"leavesTree", GrowthCraftBamboo.blocks.bambooLeaves.getBlock());
        OreDictionary.registerOre((String)"treeLeaves", GrowthCraftBamboo.blocks.bambooLeaves.getBlock());
        OreDictionary.registerOre((String)"cropBamboo", GrowthCraftBamboo.items.bamboo.getItem());
        OreDictionary.registerOre((String)"materialBamboo", GrowthCraftBamboo.items.bamboo.getItem());
        OreDictionary.registerOre((String)"bamboo", GrowthCraftBamboo.items.bamboo.getItem());
        OreDictionary.registerOre((String)"plankBamboo", (Block)GrowthCraftBamboo.blocks.bambooBlock.getBlock());
        OreDictionary.registerOre((String)"slabBamboo", (Block)GrowthCraftBamboo.blocks.bambooSingleSlab.getBlock());
        OreDictionary.registerOre((String)"stairBamboo", GrowthCraftBamboo.blocks.bambooStairs.getBlock());
        OreDictionary.registerOre((String)"treeBambooLeaves", GrowthCraftBamboo.blocks.bambooLeaves.getBlock());
        OreDictionary.registerOre((String)"foodBambooshoot", (Block)GrowthCraftBamboo.blocks.bambooShoot.getBlock());
        OreDictionary.registerOre((String)"foodBambooshoot", GrowthCraftBamboo.items.bambooShootFood.getItem());
        OreDictionary.registerOre((String)"cropBambooshoot", (Block)GrowthCraftBamboo.blocks.bambooShoot.getBlock());
        OreDictionary.registerOre((String)"listAllveggie", (Block)GrowthCraftBamboo.blocks.bambooShoot.getBlock());
        OreDictionary.registerOre((String)"cropBambooshoot", GrowthCraftBamboo.items.bambooShootFood.getItem());
        OreDictionary.registerOre((String)"listAllveggie", GrowthCraftBamboo.items.bambooShootFood.getItem());
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        VillageHandlerBamboo handler = new VillageHandlerBamboo();
        VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)handler);
        this.modules.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new BonemealEventBamboo());
        this.modules.postInit();
    }

    static {
        blocks = new GrcBambooBlocks();
        items = new GrcBambooItems();
    }
}

