/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.bamboo.common.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import growthcraft.bamboo.GrowthCraftBamboo;
import growthcraft.bamboo.common.world.WorldGenBamboo;
import growthcraft.core.common.block.ICropDataProvider;
import growthcraft.core.util.BlockCheck;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.terraingen.TerrainGen;

public class BlockBambooShoot
extends BlockBush
implements ICropDataProvider,
IGrowable {
    private final int growth;

    public BlockBambooShoot() {
        super(Material.field_151585_k);
        this.growth = GrowthCraftBamboo.getConfig().bambooShootGrowthRate;
        this.func_149672_a(field_149779_h);
        this.func_149711_c(0.0f);
        this.func_149675_a(true);
        this.func_149658_d("grcbamboo:shoot");
        float f = 0.4f;
        this.func_149676_a(0.099999994f, 0.0f, 0.099999994f, 0.9f, 0.8f, 0.9f);
        this.func_149663_c("grc.bambooShoot");
        this.func_149647_a(null);
    }

    @Override
    public float getGrowthProgress(IBlockAccess world, int x, int y, int z, int meta) {
        return (float)((double)meta / 1.0);
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        if (!world.field_72995_K) {
            super.func_149674_a(world, x, y, z, rand);
            if (world.func_72957_l(x, y + 1, z) >= 9 && rand.nextInt(this.growth) == 0) {
                this.markOrGrowMarked(world, x, y, z, rand);
            }
        }
    }

    public void func_149695_a(World world, int x, int y, int z, Block par5) {
        super.func_149695_a(world, x, y, z, par5);
        this.checkShootChange(world, x, y, z);
    }

    protected final void checkShootChange(World world, int x, int y, int z) {
        if (!this.func_149718_j(world, x, y, z)) {
            this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
            world.func_147468_f(x, y, z);
        }
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        return super.func_149742_c(world, x, y, z) && this.func_149718_j(world, x, y, z);
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        return (world.func_72883_k(x, y, z) >= 8 || world.func_72937_j(x, y, z)) && BlockCheck.canSustainPlant((IBlockAccess)world, x, y - 1, z, ForgeDirection.UP, (IPlantable)this);
    }

    @SideOnly(value=Side.CLIENT)
    public Item func_149694_d(World world, int x, int y, int z) {
        return GrowthCraftBamboo.items.bambooShootFood.getItem();
    }

    public void growBamboo(World world, int x, int y, int z, Random rand) {
        if (!TerrainGen.saplingGrowTree((World)world, (Random)rand, (int)x, (int)y, (int)z)) {
            return;
        }
        int meta = world.func_72805_g(x, y, z) & 3;
        WorldGenBamboo generator = new WorldGenBamboo(true);
        world.func_147468_f(x, y, z);
        if (!generator.func_76484_a(world, rand, x, y, z)) {
            world.func_147465_d(x, y, z, (Block)this, meta, 7);
        }
    }

    public void markOrGrowMarked(World world, int x, int y, int z, Random random) {
        int meta = world.func_72805_g(x, y, z);
        if ((meta & 8) == 0) {
            world.func_72921_c(x, y, z, meta | 8, 4);
        } else {
            this.growBamboo(world, x, y, z, random);
        }
    }

    public boolean func_149851_a(World world, int x, int y, int z, boolean isClient) {
        return true;
    }

    public boolean func_149852_a(World world, Random random, int x, int y, int z) {
        return true;
    }

    public void func_149853_b(World world, Random random, int x, int y, int z) {
        if ((double)random.nextFloat() < 0.45) {
            this.markOrGrowMarked(world, x, y, z, random);
        }
    }

    public boolean canSilkHarvest(World world, EntityPlayer player, int x, int y, int z, int metadata) {
        return false;
    }

    public Item func_149650_a(int meta, Random par2Random, int par3) {
        return GrowthCraftBamboo.items.bambooShootFood.getItem();
    }

    public int func_149645_b() {
        return 1;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return null;
    }
}

