/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.bamboo.common.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import growthcraft.bamboo.GrowthCraftBamboo;
import growthcraft.bamboo.client.renderer.RenderBamboo;
import growthcraft.bamboo.common.block.BlockBambooShoot;
import growthcraft.core.common.block.GrcBlockBase;
import growthcraft.core.util.BlockCheck;
import growthcraft.core.util.RenderUtils;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.ColorizerGrass;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockBambooStalk
extends GrcBlockBase {
    @SideOnly(value=Side.CLIENT)
    public static IIcon[] tex;
    private final int growth;

    public BlockBambooStalk() {
        super(Material.field_151575_d);
        this.growth = GrowthCraftBamboo.getConfig().bambooStalkGrowthRate;
        this.func_149672_a(field_149766_f);
        this.func_149711_c(2.0f);
        this.func_149675_a(true);
        this.func_149663_c("grc.bambooStalk");
        this.func_149647_a(null);
    }

    public boolean canPlaceTorchOnTop(World world, int x, int y, int z) {
        return true;
    }

    public int func_149738_a(World world) {
        return 5;
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        if (world.func_72805_g(x, y, z) == 0) {
            int x1 = x;
            int y1 = y;
            int z1 = z;
            if (this.isBambooOnGround(world, x, y, z) && rand.nextInt(this.growth) == 0) {
                int b = 9;
                int amount = 10;
                BlockBambooShoot bambooShoot = GrowthCraftBamboo.blocks.bambooShoot.getBlock();
                for (x1 = x - 9; x1 <= x + 9; ++x1) {
                    for (z1 = z - 9; z1 <= z + 9; ++z1) {
                        for (y1 = y - 1; y1 <= y + 1; ++y1) {
                            boolean flag2;
                            boolean flag1 = world.func_147439_a(x1, y1, z1) == this && this.isBambooOnGround(world, x1, y1, z1);
                            boolean bl = flag2 = world.func_147439_a(x1, y1, z1) == bambooShoot;
                            if (!flag1 && !flag2 || --amount > 0) continue;
                            return;
                        }
                    }
                }
                x1 = x + rand.nextInt(3) - 1;
                y1 = y + rand.nextInt(2) - rand.nextInt(2);
                z1 = z + rand.nextInt(3) - 1;
                for (int loop = 0; loop < 4; ++loop) {
                    if (world.func_147437_c(x1, y1, z1) && bambooShoot.func_149718_j(world, x1, y1, z1)) {
                        x = x1;
                        y = y1;
                        z = z1;
                    }
                    x1 = x + rand.nextInt(3) - 1;
                    y1 = y + rand.nextInt(2) - rand.nextInt(2);
                    z1 = z + rand.nextInt(3) - 1;
                }
                if (world.func_147437_c(x1, y1, z1) && bambooShoot.func_149718_j(world, x1, y1, z1)) {
                    world.func_147449_b(x1, y1, z1, (Block)bambooShoot);
                }
            }
        }
    }

    public void func_149695_a(World world, int x, int y, int z, Block s) {
        boolean flag = false;
        if (world.func_147439_a(x, y - 1, z) != this && !this.isBambooOnGround(world, x, y, z)) {
            flag = true;
        }
        if (flag && world.func_72805_g(x, y, z) == 0) {
            this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
            world.func_147468_f(x, y, z);
        }
        super.func_149695_a(world, x, y, z, s);
    }

    public void func_149749_a(World world, int x, int y, int z, Block par5, int par6) {
        if (world.func_72805_g(x, y, z) == 0) {
            int b0 = 4;
            int j1 = 5;
            if (world.func_72904_c(x - 5, y - 5, z - 5, x + 5, y + 5, z + 5)) {
                for (int x1 = -4; x1 <= 4; ++x1) {
                    for (int y1 = -4; y1 <= 4; ++y1) {
                        for (int z1 = -4; z1 <= 4; ++z1) {
                            Block block = world.func_147439_a(x + x1, y + y1, z + z1);
                            if (block == null) continue;
                            block.beginLeavesDecay(world, x + x1, y + y1, z + z1);
                        }
                    }
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public Item func_149694_d(World world, int x, int y, int z) {
        return GrowthCraftBamboo.items.bamboo.getItem();
    }

    public boolean canSustainLeaves(IBlockAccess world, int x, int y, int z) {
        return world.func_72805_g(x, y, z) == 0;
    }

    public boolean isWood(IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public boolean canBeReplacedByLeaves(IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public boolean isBambooOnGround(World world, int x, int y, int z) {
        if (!BlockCheck.canSustainPlant((IBlockAccess)world, x, y - 1, z, ForgeDirection.UP, (IPlantable)GrowthCraftBamboo.blocks.bambooShoot.getBlock())) {
            return false;
        }
        return this == world.func_147439_a(x, y, z);
    }

    public boolean canSilkHarvest(World world, EntityPlayer player, int x, int y, int z, int metadata) {
        return false;
    }

    private boolean canFence(IBlockAccess world, int x, int y, int z) {
        return world.func_147439_a(x, y, z) == GrowthCraftBamboo.blocks.bambooFence.getBlock() || world.func_147439_a(x, y, z) == Blocks.field_150396_be || world.func_147439_a(x, y, z) == GrowthCraftBamboo.blocks.bambooFenceGate.getBlock();
    }

    private boolean canWall(IBlockAccess world, int x, int y, int z) {
        return world.func_147439_a(x, y, z) == GrowthCraftBamboo.blocks.bambooWall.getBlock();
    }

    private boolean canDoor(IBlockAccess world, int x, int y, int z) {
        return world.func_147439_a(x, y, z) instanceof BlockDoor;
    }

    public Item func_149650_a(int par1, Random par2Random, int par3) {
        return GrowthCraftBamboo.items.bamboo.getItem();
    }

    public int func_149745_a(Random par1Random) {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        tex = new IIcon[5];
        BlockBambooStalk.tex[0] = reg.func_94245_a("grcbamboo:plant_top");
        BlockBambooStalk.tex[1] = reg.func_94245_a("grcbamboo:plant_nocolor");
        BlockBambooStalk.tex[2] = reg.func_94245_a("grcbamboo:plant_color");
        BlockBambooStalk.tex[3] = reg.func_94245_a("grcbamboo:block");
        BlockBambooStalk.tex[4] = reg.func_94245_a("grcbamboo:fence");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return side == 1 ? tex[0] : (side == 0 ? tex[0] : (meta == 0 ? tex[1] : tex[2]));
    }

    public int func_149645_b() {
        return RenderBamboo.id;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int s) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149635_D() {
        double d0 = 0.5;
        double d1 = 1.0;
        return ColorizerGrass.func_77480_a((double)0.5, (double)1.0);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149741_i(int par1) {
        return par1 == 0 ? 0xFFFFFF : ColorizerFoliage.func_77468_c();
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess world, int x, int y, int z) {
        if (world.func_72805_g(x, y, z) == 0) {
            int r = 0;
            int g = 0;
            int b = 0;
            for (int l1 = -1; l1 <= 1; ++l1) {
                for (int i2 = -1; i2 <= 1; ++i2) {
                    int color = world.func_72807_a(x + i2, z + l1).func_150571_c(x + i2, y, z + l1);
                    r += (color & 0xFF0000) >> 16;
                    g += (color & 0xFF00) >> 8;
                    b += color & 0xFF;
                }
            }
            return (r / 9 & 0xFF) << 16 | (g / 9 & 0xFF) << 8 | b / 9 & 0xFF;
        }
        return 0xFFFFFF;
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        float x1 = 0.25f;
        float x2 = 0.75f;
        float z1 = 0.25f;
        float z2 = 0.75f;
        if (world.func_72805_g(x, y, z) != 0) {
            if (this.canFence(world, x, y, z - 1) || this.canWall(world, x, y, z - 1) || this.canDoor(world, x, y, z - 1)) {
                z1 = 0.0f;
            }
            if (this.canFence(world, x, y, z + 1) || this.canWall(world, x, y, z + 1) || this.canDoor(world, x, y, z + 1)) {
                z2 = 1.0f;
            }
            if (this.canFence(world, x - 1, y, z) || this.canWall(world, x - 1, y, z) || this.canDoor(world, x - 1, y, z)) {
                x1 = 0.0f;
            }
            if (this.canFence(world, x + 1, y, z) || this.canWall(world, x + 1, y, z) || this.canDoor(world, x + 1, y, z)) {
                x2 = 1.0f;
            }
        }
        this.func_149676_a(x1, 0.0f, z1, x2, 1.0f, z2);
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB axis, List list, Entity entity) {
        float x1 = 0.25f;
        float x2 = 0.75f;
        float z1 = 0.25f;
        float z2 = 0.75f;
        this.func_149676_a(0.25f, 0.0f, 0.25f, 0.75f, 1.0f, 0.75f);
        super.func_149743_a(world, x, y, z, axis, list, entity);
        if (world.func_72805_g(x, y, z) != 0) {
            if (this.canFence((IBlockAccess)world, x, y, z - 1)) {
                this.renderFence(world, axis, list, entity, x, y, z, RenderUtils.Face.ZNEG);
            } else if (this.canWall((IBlockAccess)world, x, y, z - 1)) {
                this.renderWall(world, axis, list, entity, x, y, z, RenderUtils.Face.ZNEG);
            } else if (this.canDoor((IBlockAccess)world, x, y, z - 1)) {
                this.renderDoor(world, axis, list, entity, x, y, z, RenderUtils.Face.ZNEG);
            }
            if (this.canFence((IBlockAccess)world, x, y, z + 1)) {
                this.renderFence(world, axis, list, entity, x, y, z, RenderUtils.Face.ZPOS);
            } else if (this.canWall((IBlockAccess)world, x, y, z + 1)) {
                this.renderWall(world, axis, list, entity, x, y, z, RenderUtils.Face.ZPOS);
            } else if (this.canDoor((IBlockAccess)world, x, y, z + 1)) {
                this.renderDoor(world, axis, list, entity, x, y, z, RenderUtils.Face.ZPOS);
            }
            if (this.canFence((IBlockAccess)world, x - 1, y, z)) {
                this.renderFence(world, axis, list, entity, x, y, z, RenderUtils.Face.XNEG);
            } else if (this.canWall((IBlockAccess)world, x - 1, y, z)) {
                this.renderWall(world, axis, list, entity, x, y, z, RenderUtils.Face.XNEG);
            } else if (this.canDoor((IBlockAccess)world, x - 1, y, z)) {
                this.renderDoor(world, axis, list, entity, x, y, z, RenderUtils.Face.XNEG);
            }
            if (this.canFence((IBlockAccess)world, x + 1, y, z)) {
                this.renderFence(world, axis, list, entity, x, y, z, RenderUtils.Face.XPOS);
            } else if (this.canWall((IBlockAccess)world, x + 1, y, z)) {
                this.renderWall(world, axis, list, entity, x, y, z, RenderUtils.Face.XPOS);
            } else if (this.canDoor((IBlockAccess)world, x + 1, y, z)) {
                this.renderDoor(world, axis, list, entity, x, y, z, RenderUtils.Face.XPOS);
            }
        }
        this.func_149719_a((IBlockAccess)world, x, y, z);
    }

    private void renderFence(World world, AxisAlignedBB axis, List list, Entity entity, int x, int y, int z, RenderUtils.Face m) {
        float x1 = x;
        float x2 = (float)x + 1.0f;
        float z1 = z;
        float z2 = (float)z + 1.0f;
        float y1 = 0.75f;
        float y2 = 0.9375f;
        if (m == RenderUtils.Face.ZNEG) {
            x1 = 0.4375f;
            x2 = 0.5625f;
            z1 = 0.0f;
            z2 = 0.25f;
        } else if (m == RenderUtils.Face.ZPOS) {
            x1 = 0.4375f;
            x2 = 0.5625f;
            z1 = 0.75f;
            z2 = 1.0f;
        } else if (m == RenderUtils.Face.XNEG) {
            z1 = 0.4375f;
            z2 = 0.5625f;
            x1 = 0.0f;
            x2 = 0.25f;
        } else if (m == RenderUtils.Face.XPOS) {
            z1 = 0.4375f;
            z2 = 0.5625f;
            x1 = 0.75f;
            x2 = 1.0f;
        }
        this.func_149676_a(x1, y1, z1, x2, y2, z2);
        super.func_149743_a(world, x, y, z, axis, list, entity);
        y1 = 0.375f;
        y2 = 0.5625f;
        if (m == RenderUtils.Face.ZNEG) {
            x1 = 0.4375f;
            x2 = 0.5625f;
            z1 = 0.0f;
            z2 = 0.25f;
        } else if (m == RenderUtils.Face.ZPOS) {
            x1 = 0.4375f;
            x2 = 0.5625f;
            z1 = 0.75f;
            z2 = 1.0f;
        } else if (m == RenderUtils.Face.XNEG) {
            z1 = 0.4375f;
            z2 = 0.5625f;
            x1 = 0.0f;
            x2 = 0.25f;
        } else if (m == RenderUtils.Face.XPOS) {
            z1 = 0.4375f;
            z2 = 0.5625f;
            x1 = 0.75f;
            x2 = 1.0f;
        }
        this.func_149676_a(x1, y1, z1, x2, y2, z2);
        super.func_149743_a(world, x, y, z, axis, list, entity);
    }

    private void renderWall(World world, AxisAlignedBB axis, List list, Entity entity, int x, int y, int z, RenderUtils.Face m) {
        float x1 = x;
        float x2 = (float)x + 1.0f;
        float z1 = z;
        float z2 = (float)z + 1.0f;
        double y1 = 0.0;
        double y2 = 1.0;
        if (m == RenderUtils.Face.ZNEG) {
            x1 = 0.375f;
            x2 = 0.625f;
            z1 = 0.0f;
            z2 = 0.25f;
        } else if (m == RenderUtils.Face.ZPOS) {
            x1 = 0.375f;
            x2 = 0.625f;
            z1 = 0.75f;
            z2 = 1.0f;
        } else if (m == RenderUtils.Face.XNEG) {
            z1 = 0.375f;
            z2 = 0.625f;
            x1 = 0.0f;
            x2 = 0.25f;
        } else if (m == RenderUtils.Face.XPOS) {
            z1 = 0.375f;
            z2 = 0.625f;
            x1 = 0.75f;
            x2 = 1.0f;
        }
        this.func_149676_a(x1, 0.0f, z1, x2, 1.0f, z2);
        super.func_149743_a(world, x, y, z, axis, list, entity);
    }

    private void renderDoor(World world, AxisAlignedBB axis, List list, Entity entity, int x, int y, int z, RenderUtils.Face m) {
        float x1 = x;
        float x2 = (float)x + 1.0f;
        float z1 = z;
        float z2 = (float)z + 1.0f;
        float y1 = 0.0f;
        float y2 = 1.0f;
        if (m == RenderUtils.Face.ZNEG) {
            int tm;
            int tm0 = world.func_72805_g(x, y, z - 1);
            if ((tm0 & 8) > 7) {
                tm0 = world.func_72805_g(x, y - 1, z - 1);
            }
            if ((tm = tm0 & 3) == 0) {
                x1 = 0.0f;
                x2 = 0.375f;
                z1 = 0.0f;
                z2 = 0.25f;
                this.func_149676_a(x1, 0.0f, z1, x2, 1.0f, z2);
                super.func_149743_a(world, x, y, z, axis, list, entity);
            }
            if (tm == 2) {
                x1 = 0.625f;
                x2 = 1.0f;
                z1 = 0.0f;
                z2 = 0.25f;
                this.func_149676_a(x1, 0.0f, z1, x2, 1.0f, z2);
                super.func_149743_a(world, x, y, z, axis, list, entity);
            }
        } else if (m == RenderUtils.Face.ZPOS) {
            int tm;
            int tm0 = world.func_72805_g(x, y, z + 1);
            if ((tm0 & 8) > 7) {
                tm0 = world.func_72805_g(x, y - 1, z + 1);
            }
            if ((tm = tm0 & 3) == 0) {
                x1 = 0.0f;
                x2 = 0.375f;
                z1 = 0.75f;
                z2 = 1.0f;
                this.func_149676_a(x1, 0.0f, z1, x2, 1.0f, z2);
                super.func_149743_a(world, x, y, z, axis, list, entity);
            }
            if (tm == 2) {
                x1 = 0.625f;
                x2 = 1.0f;
                z1 = 0.75f;
                z2 = 1.0f;
                this.func_149676_a(x1, 0.0f, z1, x2, 1.0f, z2);
                super.func_149743_a(world, x, y, z, axis, list, entity);
            }
        } else if (m == RenderUtils.Face.XNEG) {
            int tm;
            int tm0 = world.func_72805_g(x - 1, y, z);
            if ((tm0 & 8) > 7) {
                tm0 = world.func_72805_g(x - 1, y - 1, z);
            }
            if ((tm = tm0 & 3) == 1) {
                x1 = 0.0f;
                x2 = 0.25f;
                z1 = 0.0f;
                z2 = 0.375f;
                this.func_149676_a(x1, 0.0f, z1, x2, 1.0f, z2);
                super.func_149743_a(world, x, y, z, axis, list, entity);
            }
            if (tm == 3) {
                x1 = 0.0f;
                x2 = 0.25f;
                z1 = 0.625f;
                z2 = 1.0f;
                this.func_149676_a(x1, 0.0f, z1, x2, 1.0f, z2);
                super.func_149743_a(world, x, y, z, axis, list, entity);
            }
        } else if (m == RenderUtils.Face.XPOS) {
            int tm;
            int tm0 = world.func_72805_g(x + 1, y, z);
            if ((tm0 & 8) > 7) {
                tm0 = world.func_72805_g(x + 1, y - 1, z);
            }
            if ((tm = tm0 & 3) == 1) {
                x1 = 0.75f;
                x2 = 1.0f;
                z1 = 0.0f;
                z2 = 0.375f;
                this.func_149676_a(x1, 0.0f, z1, x2, 1.0f, z2);
                super.func_149743_a(world, x, y, z, axis, list, entity);
            }
            if (tm == 3) {
                x1 = 0.75f;
                x2 = 1.0f;
                z1 = 0.625f;
                z2 = 1.0f;
                this.func_149676_a(x1, 0.0f, z1, x2, 1.0f, z2);
                super.func_149743_a(world, x, y, z, axis, list, entity);
            }
        }
    }
}

