/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.bamboo.common.world;

import growthcraft.bamboo.GrowthCraftBamboo;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public class WorldGenBamboo
extends WorldGenAbstractTree {
    private final int density;
    private final int minTreeHeight;
    private final int maxTreeHeight;
    private final Block leaves;
    private final Block log;

    public WorldGenBamboo(boolean doblocknotify) {
        super(doblocknotify);
        this.density = GrowthCraftBamboo.getConfig().bambooWorldGenDensity;
        this.minTreeHeight = GrowthCraftBamboo.getConfig().bambooTreeMinHeight;
        this.maxTreeHeight = GrowthCraftBamboo.getConfig().bambooTreeMaxHeight;
        this.leaves = GrowthCraftBamboo.blocks.bambooLeaves.getBlock();
        this.log = GrowthCraftBamboo.blocks.bambooStalk.getBlock();
    }

    public boolean generateClumps(World world, Random rand, int i, int j, int k) {
        for (int loop = 0; loop < this.density; ++loop) {
            int x = i + rand.nextInt(8) - rand.nextInt(8);
            int y = j + rand.nextInt(4) - rand.nextInt(4);
            int z = k + rand.nextInt(8) - rand.nextInt(8);
            this.func_76484_a(world, rand, x, y, z);
        }
        return true;
    }

    public boolean func_76484_a(World world, Random rand, int i, int j, int k) {
        int height = rand.nextInt(3) + this.minTreeHeight;
        boolean flag = true;
        if (j >= 1 && j + height + 1 <= this.maxTreeHeight) {
            boolean isSoil;
            int z;
            int x;
            int y;
            for (y = j; y <= j + 1 + height; ++y) {
                int b0 = 0;
                if (y >= j + height - 3) {
                    b0 = 1;
                }
                for (x = i - b0; x <= i + b0 && flag; ++x) {
                    for (z = k - b0; z <= k + b0 && flag; ++z) {
                        if (y >= 0 && y < this.maxTreeHeight) {
                            Block checkBlock = world.func_147439_a(x, y, z);
                            if (this.isReplaceable(world, x, y, z)) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            Block soil = world.func_147439_a(i, j - 1, k);
            boolean bl = isSoil = soil != null && soil.canSustainPlant((IBlockAccess)world, i, j - 1, k, ForgeDirection.UP, (IPlantable)((BlockSapling)Blocks.field_150345_g));
            if (isSoil && j < this.maxTreeHeight - height - 1) {
                Block block;
                int it;
                soil.onPlantGrow(world, i, j - 1, k, i, j, k);
                for (it = 0; it <= 3; ++it) {
                    y = j + 5 + height - this.minTreeHeight + it * 2;
                    for (x = i - 1; x <= i + 1; ++x) {
                        int x2 = x - i;
                        for (z = k - 1; z <= k + 1; ++z) {
                            int z2 = z - k;
                            block = world.func_147439_a(x, y, z);
                            if (Math.abs(x2) == 1 && Math.abs(z2) == 1 || block != null && !block.canBeReplacedByLeaves((IBlockAccess)world, x, y, z)) continue;
                            this.func_150516_a(world, x, y, z, this.leaves, 0);
                        }
                    }
                }
                y = j + height - 2;
                for (x = i - 1; x <= i + 1; ++x) {
                    for (z = k - 1; z <= k + 1; ++z) {
                        block = world.func_147439_a(x, y, z);
                        if (block != null && !block.canBeReplacedByLeaves((IBlockAccess)world, x, y, z)) continue;
                        this.func_150516_a(world, x, y, z, this.leaves, 0);
                    }
                }
                x = i;
                z = k;
                for (it = 0; it <= 3; ++it) {
                    switch (it) {
                        case 0: {
                            x = i - 2;
                            z = k;
                            break;
                        }
                        case 1: {
                            x = i + 2;
                            z = k;
                            break;
                        }
                        case 2: {
                            x = i;
                            z = k - 2;
                            break;
                        }
                        case 3: {
                            x = i;
                            z = k + 2;
                            break;
                        }
                    }
                    block = world.func_147439_a(x, y, z);
                    if (block != null && !block.canBeReplacedByLeaves((IBlockAccess)world, x, y, z)) continue;
                    this.func_150516_a(world, x, y, z, this.leaves, 0);
                }
                y = j + height;
                block = world.func_147439_a(i, y, k);
                if (block == null || block.canBeReplacedByLeaves((IBlockAccess)world, i, y, k)) {
                    this.func_150516_a(world, i, y, k, this.leaves, 0);
                }
                for (y = 0; y < height - 1; ++y) {
                    block = world.func_147439_a(i, j + y, k);
                    if (!block.isAir((IBlockAccess)world, it, j + y, k) && !block.isLeaves((IBlockAccess)world, i, j + y, k)) continue;
                    this.func_150516_a(world, i, j + y, k, this.log, 0);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    protected boolean func_150523_a(Block block) {
        return block.func_149688_o() == Material.field_151579_a || block.func_149688_o() == Material.field_151584_j || block == Blocks.field_150349_c || block == Blocks.field_150346_d || block == Blocks.field_150364_r || block == Blocks.field_150363_s || block == Blocks.field_150345_g || block == Blocks.field_150395_bd;
    }

    protected boolean isReplaceable(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        return block.isAir((IBlockAccess)world, x, y, z) || block.isLeaves((IBlockAccess)world, x, y, z) || block.isWood((IBlockAccess)world, x, y, z) || this.func_150523_a(block);
    }
}

