/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.bees.common.block;

import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public enum EnumBeeBoxForestry {
    LARCH("larch"),
    TEAK("teak"),
    ACACIA("acacia"),
    LIME("lime"),
    CHESTNUT("chestnut"),
    WENGE("wenge"),
    BAOBAB("baobab"),
    SEQUOIA("sequoia", 4.0f),
    KAPOK("kapok"),
    EBONY("ebony"),
    MAHOGANY("mahogany"),
    BALSA("balsa", 1.0f),
    WILLOW("willow"),
    WALNUT("walnut"),
    GREENHEART("greenheart", 7.5f),
    CHERRY("cherry"),
    MAHOE("mahoe"),
    POPLAR("poplar"),
    PALM("palm"),
    PAPAYA("papaya"),
    PINE("pine", 3.0f),
    PLUM("plum"),
    MAPLE("maple"),
    CITRUS("citrus"),
    GIGANTEUM("giganteum"),
    IPE("ipe"),
    PADAUK("padauk"),
    COCOBOLO("cocobolo"),
    ZEBRAWOOD("zebrawood");

    public static final EnumBeeBoxForestry[] VALUES;
    public static final EnumBeeBoxForestry[][] ROWS;
    public final String name;
    public final float hardness;
    public final int meta;
    public final int col;
    public final int row;

    private EnumBeeBoxForestry(String n2, float h) {
        this.name = n2;
        this.hardness = h;
        this.meta = this.ordinal();
        this.col = this.meta % 15;
        this.row = this.meta / 15;
    }

    private EnumBeeBoxForestry(String n2) {
        this(n2, 2.0f);
    }

    public float getHardness() {
        return this.hardness;
    }

    public NBTTagCompound newWoodTag() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("WoodType", this.ordinal());
        return tag;
    }

    public ItemStack getForestryWoodStack(String blockname) {
        Block block = GameRegistry.findBlock((String)"Forestry", (String)blockname);
        if (block != null) {
            ItemStack result = new ItemStack(block);
            result.func_77982_d(this.newWoodTag());
            return result;
        }
        return null;
    }

    public ItemStack getForestryPlanksStack() {
        return this.getForestryWoodStack("planks");
    }

    public ItemStack getForestryFireproofPlanksStack() {
        return this.getForestryWoodStack("planksFireproof");
    }

    static {
        VALUES = EnumBeeBoxForestry.values();
        ROWS = new EnumBeeBoxForestry[][]{{LARCH, TEAK, ACACIA, LIME, CHESTNUT, WENGE, BAOBAB, SEQUOIA, KAPOK, EBONY, MAHOGANY, BALSA, WILLOW, WALNUT, GREENHEART}, {CHERRY, MAHOE, POPLAR, PALM, PAPAYA, PINE, PLUM, MAPLE, CITRUS, GIGANTEUM, IPE, PADAUK, COCOBOLO, ZEBRAWOOD}};
    }
}

