/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.bees.common.tileentity.device;

import growthcraft.api.bees.BeesRegistry;
import growthcraft.api.bees.IFlowerBlockEntry;
import growthcraft.api.core.util.RandomUtils;
import growthcraft.bees.GrowthCraftBees;
import growthcraft.bees.common.tileentity.TileEntityBeeBox;
import growthcraft.core.common.tileentity.device.DeviceBase;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class DeviceBeeBox
extends DeviceBase {
    public List<List> flowerList = new ArrayList<List>();
    private final float honeyCombSpawnRate;
    private final float honeySpawnRate;
    private final float beeSpawnRate;
    private final float flowerSpawnRate;
    private final int flowerRadius;
    private final float bonus;
    private Random random;
    private int bonusTime;

    public DeviceBeeBox(TileEntityBeeBox te) {
        super(te);
        this.honeyCombSpawnRate = GrowthCraftBees.getConfig().beeBoxHoneyCombSpawnRate;
        this.honeySpawnRate = GrowthCraftBees.getConfig().beeBoxHoneySpawnRate;
        this.beeSpawnRate = GrowthCraftBees.getConfig().beeBoxBeeSpawnRate;
        this.flowerSpawnRate = GrowthCraftBees.getConfig().beeBoxFlowerSpawnRate;
        this.flowerRadius = GrowthCraftBees.getConfig().beeBoxFlowerRadius;
        this.bonus = GrowthCraftBees.getConfig().beeBoxBonusMultiplier;
        this.random = new Random();
    }

    protected TileEntityBeeBox getParentTile() {
        if (this.parent instanceof TileEntityBeeBox) {
            return (TileEntityBeeBox)this.parent;
        }
        return null;
    }

    public int getBonusTime(int t) {
        return this.bonusTime;
    }

    public void setBonusTime(int t) {
        this.bonusTime = t;
    }

    public boolean hasBonus() {
        return this.bonusTime > 0;
    }

    private boolean canDoWork() {
        if (this.getWorld().func_72951_B(this.parent.field_145851_c, this.parent.field_145848_d + 1, this.parent.field_145849_e)) {
            return false;
        }
        return this.getWorld().func_72957_l(this.parent.field_145851_c, this.parent.field_145848_d + 1, this.parent.field_145849_e) >= 7;
    }

    private boolean isBlockFlower(Block block, int meta) {
        return BeesRegistry.instance().isBlockFlower(block, meta);
    }

    private List<List> gatherFlowersInRadius(World world, int x, int y, int z, int checkSize, List<List> list) {
        int i = x - (checkSize - 1) / 2;
        int k = z - (checkSize - 1) / 2;
        for (int xLoop = -checkSize; xLoop < checkSize; ++xLoop) {
            for (int yLoop = -checkSize; yLoop < checkSize; ++yLoop) {
                int fx = i + xLoop;
                int fy = y;
                int fz = k + yLoop;
                if (world.func_147437_c(fx, fy, fz)) continue;
                Block flower = world.func_147439_a(fx, y, fz);
                int fm = world.func_72805_g(fx, y, fz);
                if (flower == null || !this.isBlockFlower(flower, fm)) continue;
                list.add(Arrays.asList(flower, fm));
            }
        }
        return list;
    }

    private float calcGrowthRate(World world, int x, int y, int z) {
        int checkSize = 5;
        int i = x - 2;
        int k = z - 2;
        float f = 1.0f;
        for (int loopx = -5; loopx < 5; ++loopx) {
            for (int loopz = -5; loopz < 5; ++loopz) {
                Block flower = world.func_147439_a(i + loopx, y, k + loopz);
                int fm = world.func_72805_g(i + loopx, y, k + loopz);
                Block soil = world.func_147439_a(i + loopx, y - 1, k + loopz);
                float f1 = 0.0f;
                if (soil == Blocks.field_150349_c) {
                    f1 = 0.36f;
                    if (this.isBlockFlower(flower, fm)) {
                        f1 = 1.08f;
                    }
                } else if (flower == Blocks.field_150457_bL && (world.func_72805_g(i + loopx, y, k + loopz) == 1 || world.func_72805_g(i + loopx, y, k + loopz) == 2)) {
                    f1 = 0.72f;
                }
                f += (f1 /= 4.0f);
            }
        }
        TileEntityBeeBox te = this.getParentTile();
        if (te != null) {
            int bees = te.countBees();
            float div = 2.0f - 0.015625f * (float)bees;
            f /= div;
            if (te.hasBonus()) {
                f *= this.bonus;
            }
        }
        return f;
    }

    public float getGrowthRate() {
        return this.calcGrowthRate(this.getWorld(), this.parent.field_145851_c, this.parent.field_145848_d, this.parent.field_145849_e);
    }

    public void update() {
        if (this.bonusTime > 0) {
            --this.bonusTime;
        }
    }

    protected int honeyCombBias() {
        TileEntityBeeBox te = this.getParentTile();
        int empty = te.countEmptyCombs();
        int filled = te.countHoney();
        return filled - empty;
    }

    public void updateTick() {
        int spawnRate;
        TileEntityBeeBox te = this.getParentTile();
        if (!this.canDoWork() || !te.hasBees()) {
            return;
        }
        int x = te.field_145851_c;
        int y = te.field_145848_d;
        int z = te.field_145849_e;
        float f = this.getGrowthRate();
        if (!te.hasMaxBees() && this.random.nextInt((int)(this.beeSpawnRate / f) + 1) == 0) {
            te.spawnBee();
        }
        int maxCombs = te.getHoneyCombMax();
        int curCombs = te.countCombs();
        if (te.countHoney() < maxCombs) {
            int biasSpawn;
            boolean shouldFill;
            int bias = this.honeyCombBias();
            boolean bl = shouldFill = bias < 0;
            if (bias != 0 && curCombs < maxCombs && (biasSpawn = Math.min(MathHelper.func_76130_a((int)bias), 6)) > 0 && this.random.nextInt(biasSpawn) == 0) {
                boolean bl2 = shouldFill = !shouldFill;
            }
            if (shouldFill) {
                if (this.random.nextInt((int)(this.honeySpawnRate / f) + 1) == 0) {
                    te.fillHoneyComb();
                }
            } else if (this.random.nextInt((int)(this.honeyCombSpawnRate / f) + 1) == 0) {
                te.spawnHoneyComb();
            }
        }
        f = 7.48f / (2.0f - 0.015625f * (float)te.countBees());
        if (te.hasBonus()) {
            f *= this.bonus;
        }
        if (this.random.nextInt(spawnRate = (int)(this.flowerSpawnRate / f) + 1) == 0) {
            int checkSize = this.flowerRadius;
            this.flowerList.clear();
            this.gatherFlowersInRadius(this.getWorld(), x, y, z, checkSize, this.flowerList);
            if (!this.flowerList.isEmpty()) {
                int random_x = x + this.random.nextInt(checkSize * 2) - checkSize;
                int random_z = z + this.random.nextInt(checkSize * 2) - checkSize;
                List randomList = RandomUtils.sample(this.random, this.flowerList);
                if (randomList != null) {
                    Block block = (Block)randomList.get(0);
                    int meta = (Integer)randomList.get(1);
                    IFlowerBlockEntry entry = BeesRegistry.instance().getFlowerBlockEntry(block, meta);
                    if (entry != null && entry.canPlaceAt(this.getWorld(), random_x, y, random_z)) {
                        this.getWorld().func_147465_d(random_x, y, random_z, block, meta, 2);
                    }
                }
            }
        }
    }

    public void updateClientTick() {
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.bonusTime = data.func_74762_e("bonus_time");
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74768_a("bonus_time", this.bonusTime);
    }

    @Override
    public boolean readFromStream(ByteBuf buf) {
        super.readFromStream(buf);
        this.bonusTime = buf.readInt();
        return false;
    }

    @Override
    public boolean writeToStream(ByteBuf buf) {
        super.writeToStream(buf);
        buf.writeInt(this.bonusTime);
        return false;
    }
}

