/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.common.block;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import growthcraft.cellar.GrowthCraftCellar;
import growthcraft.cellar.client.render.RenderFermentBarrel;
import growthcraft.cellar.common.block.BlockCellarContainer;
import growthcraft.cellar.common.tileentity.TileEntityFermentBarrel;
import growthcraft.cellar.event.EventBarrelDrained;
import growthcraft.core.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class BlockFermentBarrel
extends BlockCellarContainer {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;

    public BlockFermentBarrel() {
        super(Material.field_151575_d);
        this.setTileEntityType(TileEntityFermentBarrel.class);
        this.func_149711_c(2.5f);
        this.func_149672_a(field_149766_f);
        this.func_149663_c("grc.fermentBarrel");
        this.func_149658_d("grccellar:ferment_barrel");
        this.func_149647_a(GrowthCraftCellar.tab);
    }

    @Override
    protected boolean shouldRestoreBlockState(World world, int x, int y, int z, ItemStack stack) {
        return true;
    }

    @Override
    protected boolean shouldDropTileStack(World world, int x, int y, int z, int metadata, int fortune) {
        return true;
    }

    @Override
    public boolean isRotatable(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return true;
    }

    @Override
    protected boolean playerDrainTank(World world, int x, int y, int z, IFluidHandler tank, ItemStack held, EntityPlayer player) {
        FluidStack available = Utils.playerDrainTank(world, x, y, z, tank, held, player);
        if (available != null && available.amount > 0) {
            GrowthCraftCellar.CELLAR_BUS.post((Event)new EventBarrelDrained(player, world, x, y, z, available));
            return true;
        }
        return false;
    }

    private void setDefaultDirection(World world, int x, int y, int z) {
        if (!world.field_72995_K) {
            Block southBlock = world.func_147439_a(x, y, z - 1);
            Block northBlock = world.func_147439_a(x, y, z + 1);
            Block westBlock = world.func_147439_a(x - 1, y, z);
            Block eastBlock = world.func_147439_a(x + 1, y, z);
            int meta = 3;
            if (southBlock.func_149730_j() && !northBlock.func_149730_j()) {
                meta = 3;
            }
            if (northBlock.func_149730_j() && !southBlock.func_149730_j()) {
                meta = 2;
            }
            if (westBlock.func_149730_j() && !eastBlock.func_149730_j()) {
                meta = 5;
            }
            if (eastBlock.func_149730_j() && !westBlock.func_149730_j()) {
                meta = 4;
            }
            world.func_72921_c(x, y, z, meta, 3);
        }
    }

    public void func_149726_b(World world, int x, int y, int z) {
        super.func_149726_b(world, x, y, z);
        this.setDefaultDirection(world, x, y, z);
    }

    @Override
    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        super.func_149689_a(world, x, y, z, entity, stack);
        int meta = BlockPistonBase.func_150071_a((World)world, (int)x, (int)y, (int)z, (EntityLivingBase)entity);
        world.func_72921_c(x, y, z, meta, 3);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        this.icons = new IIcon[4];
        String basename = this.func_149641_N();
        this.icons[0] = reg.func_94245_a(String.format("%s/minecraft/oak/side", basename));
        this.icons[1] = reg.func_94245_a(String.format("%s/minecraft/oak/side_alt", basename));
        this.icons[2] = reg.func_94245_a(String.format("%s/minecraft/oak/top", basename));
        this.icons[3] = reg.func_94245_a(String.format("%s/minecraft/oak/bottom", basename));
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconByIndex(int index) {
        return this.icons[index];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (meta == 0 || meta == 1) {
            return side == 0 || side == 1 ? this.icons[1] : this.icons[0];
        }
        if (meta == 2 || meta == 3) {
            return side == 2 || side == 3 ? this.icons[1] : this.icons[0];
        }
        if (meta == 4 || meta == 5) {
            return side == 4 || side == 5 ? this.icons[1] : this.icons[0];
        }
        return this.icons[0];
    }

    public int func_149645_b() {
        return RenderFermentBarrel.RENDER_ID;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        return true;
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_149736_g(World world, int x, int y, int z, int par5) {
        TileEntityFermentBarrel te = (TileEntityFermentBarrel)this.getTileEntity((IBlockAccess)world, x, y, z);
        if (te != null) {
            return te.getDeviceProgressScaled(15);
        }
        return 0;
    }
}

