/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.common.tileentity;

import growthcraft.cellar.GrowthCraftCellar;
import growthcraft.cellar.common.fluids.CellarTank;
import growthcraft.cellar.common.inventory.ContainerBrewKettle;
import growthcraft.cellar.common.tileentity.TileEntityCellarDevice;
import growthcraft.cellar.common.tileentity.device.BrewKettle;
import growthcraft.core.common.inventory.GrcInternalInventory;
import growthcraft.core.common.tileentity.event.TileEventHandler;
import growthcraft.core.common.tileentity.feature.ITileHeatedDevice;
import growthcraft.core.common.tileentity.feature.ITileProgressiveDevice;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class TileEntityBrewKettle
extends TileEntityCellarDevice
implements ITileHeatedDevice,
ITileProgressiveDevice {
    private static final int[] rawSlotIDs = new int[]{0, 1};
    private static final int[] residueSlotIDs = new int[]{0};
    private BrewKettle brewKettle = new BrewKettle(this, 0, 1, 0, 1);

    @Override
    protected FluidTank[] createTanks() {
        int maxCap = GrowthCraftCellar.getConfig().brewKettleMaxCap;
        return new FluidTank[]{new CellarTank(maxCap, this), new CellarTank(maxCap, this)};
    }

    @Override
    public GrcInternalInventory createInventory() {
        return new GrcInternalInventory(this, 2);
    }

    @Override
    protected void markFluidDirty() {
        this.markForUpdate();
    }

    @Override
    public String getDefaultInventoryName() {
        return "container.grc.brewKettle";
    }

    @Override
    public String getGuiID() {
        return "grccellar:brew_kettle";
    }

    @Override
    public Container createContainer(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerBrewKettle(playerInventory, this);
    }

    @Override
    public float getDeviceProgress() {
        return this.brewKettle.getProgress();
    }

    @Override
    public int getDeviceProgressScaled(int scale) {
        return this.brewKettle.getProgressScaled(scale);
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            this.brewKettle.update();
        }
    }

    @Override
    public int getHeatScaled(int range) {
        return (int)(MathHelper.func_76131_a((float)this.brewKettle.getHeatMultiplier(), (float)0.0f, (float)1.0f) * (float)range);
    }

    @Override
    public boolean isHeated() {
        return this.brewKettle.isHeated();
    }

    @Override
    public float getHeatMultiplier() {
        return this.brewKettle.getHeatMultiplier();
    }

    public boolean canBrew() {
        return this.brewKettle.canBrew();
    }

    @Override
    public int[] func_94128_d(int side) {
        return side == 0 ? rawSlotIDs : residueSlotIDs;
    }

    @Override
    public boolean func_102008_b(int index, ItemStack stack, int side) {
        return side != 0 || index == 1;
    }

    @TileEventHandler(event=TileEventHandler.EventType.NBT_READ)
    public void readFromNBT_BrewKettle(NBTTagCompound nbt) {
        if (nbt.func_74764_b("time")) {
            this.brewKettle.setTime(nbt.func_74765_d("time"));
            this.brewKettle.setGrain(nbt.func_74760_g("grain"));
        } else {
            this.brewKettle.readFromNBT(nbt, "brew_kettle");
        }
    }

    @TileEventHandler(event=TileEventHandler.EventType.NBT_WRITE)
    public void writeToNBT_BrewKettle(NBTTagCompound nbt) {
        this.brewKettle.writeToNBT(nbt, "brew_kettle");
    }

    @TileEventHandler(event=TileEventHandler.EventType.NETWORK_READ)
    public boolean readFromStream_BrewKettle(ByteBuf stream) throws IOException {
        this.brewKettle.readFromStream(stream);
        return false;
    }

    @TileEventHandler(event=TileEventHandler.EventType.NETWORK_WRITE)
    public boolean writeToStream_BrewKettle(ByteBuf stream) throws IOException {
        this.brewKettle.writeToStream(stream);
        return false;
    }

    @Override
    public void receiveGUINetworkData(int id, int v) {
        super.receiveGUINetworkData(id, v);
        BrewKettleDataID dataId = BrewKettleDataID.getByOrdinal(id);
        switch (dataId) {
            case TIME: {
                this.brewKettle.setTime(v);
                break;
            }
            case TIME_MAX: {
                this.brewKettle.setTimeMax(v);
                break;
            }
            case HEAT_AMOUNT: {
                this.brewKettle.setHeatMultiplier((float)v / 32767.0f);
                break;
            }
        }
    }

    @Override
    public void sendGUINetworkData(Container container, ICrafting iCrafting) {
        super.sendGUINetworkData(container, iCrafting);
        iCrafting.func_71112_a(container, BrewKettleDataID.TIME.ordinal(), (int)this.brewKettle.getTime());
        iCrafting.func_71112_a(container, BrewKettleDataID.TIME_MAX.ordinal(), (int)this.brewKettle.getTimeMax());
        iCrafting.func_71112_a(container, BrewKettleDataID.HEAT_AMOUNT.ordinal(), (int)(this.brewKettle.getHeatMultiplier() * 32767.0f));
    }

    @Override
    protected int doFill(ForgeDirection from, FluidStack resource, boolean shouldFill) {
        return this.fillFluidTank(0, resource, shouldFill);
    }

    @Override
    protected FluidStack doDrain(ForgeDirection from, int maxDrain, boolean shouldDrain) {
        return this.drainFluidTank(1, maxDrain, shouldDrain);
    }

    @Override
    protected FluidStack doDrain(ForgeDirection from, FluidStack stack, boolean shouldDrain) {
        if (stack == null || !stack.isFluidEqual(this.getFluidStack(1))) {
            return null;
        }
        return this.doDrain(from, stack.amount, shouldDrain);
    }

    public void switchTanks() {
        FluidStack f0 = null;
        FluidStack f1 = null;
        if (this.getFluidStack(0) != null) {
            f0 = this.getFluidStack(0).copy();
        }
        if (this.getFluidStack(1) != null) {
            f1 = this.getFluidStack(1).copy();
        }
        this.clearTank(0);
        this.clearTank(1);
        this.getFluidTank(0).fill(f1, true);
        this.getFluidTank(1).fill(f0, true);
        this.markForUpdate();
    }

    public static enum BrewKettleDataID {
        TIME,
        TIME_MAX,
        HEAT_AMOUNT,
        UNKNOWN;

        public static final BrewKettleDataID[] VALUES;

        public static BrewKettleDataID getByOrdinal(int ord) {
            if (ord >= 0 && ord < VALUES.length) {
                return VALUES[ord];
            }
            return UNKNOWN;
        }

        static {
            VALUES = new BrewKettleDataID[]{TIME, TIME_MAX, HEAT_AMOUNT};
        }
    }
}

