/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.common.tileentity;

import growthcraft.api.cellar.CellarRegistry;
import growthcraft.api.cellar.fermenting.IFermentationRecipe;
import growthcraft.api.core.definition.IMultiItemStacks;
import growthcraft.api.core.fluids.FluidTest;
import growthcraft.api.core.fluids.FluidUtils;
import growthcraft.api.core.nbt.INBTItemSerializable;
import growthcraft.api.core.nbt.NBTHelper;
import growthcraft.cellar.GrowthCraftCellar;
import growthcraft.cellar.common.fluids.CellarTank;
import growthcraft.cellar.common.inventory.ContainerFermentBarrel;
import growthcraft.cellar.common.tileentity.TileEntityCellarDevice;
import growthcraft.core.common.inventory.GrcInternalInventory;
import growthcraft.core.common.inventory.InventoryProcessor;
import growthcraft.core.common.tileentity.event.TileEventHandler;
import growthcraft.core.common.tileentity.feature.ITileProgressiveDevice;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class TileEntityFermentBarrel
extends TileEntityCellarDevice
implements ITileProgressiveDevice,
INBTItemSerializable {
    private static final int[] accessableSlotIds = new int[]{0};
    protected int time;
    private int timemax;
    private boolean shouldUseCachedRecipe;
    private boolean recheckRecipe;
    private boolean lidOn;
    private IFermentationRecipe activeRecipe;

    public TileEntityFermentBarrel() {
        this.timemax = GrowthCraftCellar.getConfig().fermentTime;
        this.shouldUseCachedRecipe = GrowthCraftCellar.getConfig().fermentBarrelUseCachedRecipe;
        this.recheckRecipe = true;
        this.lidOn = true;
    }

    @Override
    protected FluidTank[] createTanks() {
        return new FluidTank[]{new CellarTank(GrowthCraftCellar.getConfig().fermentBarrelMaxCap, this)};
    }

    @Override
    public GrcInternalInventory createInventory() {
        return new GrcInternalInventory(this, 2);
    }

    @Override
    public String getDefaultInventoryName() {
        return "container.grc.fermentBarrel";
    }

    @Override
    public String getGuiID() {
        return "grccellar:ferment_barrel";
    }

    @Override
    public Container createContainer(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerFermentBarrel(playerInventory, this);
    }

    protected void markForRecipeRecheck() {
        this.recheckRecipe = true;
    }

    protected boolean resetTime() {
        if (this.time != 0) {
            this.time = 0;
            return true;
        }
        return false;
    }

    private IFermentationRecipe loadRecipe() {
        return CellarRegistry.instance().fermenting().findRecipe(this.getFluidStack(0), this.func_70301_a(0));
    }

    private IFermentationRecipe refreshRecipe() {
        IFermentationRecipe recipe = this.loadRecipe();
        if (recipe != null && recipe != this.activeRecipe) {
            if (this.activeRecipe != null) {
                this.resetTime();
            }
            this.activeRecipe = recipe;
            this.func_70296_d();
        } else if (this.activeRecipe != null) {
            this.activeRecipe = null;
            this.resetTime();
            this.func_70296_d();
        }
        return this.activeRecipe;
    }

    private IFermentationRecipe getWorkingRecipe() {
        if (this.shouldUseCachedRecipe) {
            if (this.activeRecipe == null) {
                this.refreshRecipe();
            }
            return this.activeRecipe;
        }
        return this.loadRecipe();
    }

    public int getTime() {
        return this.time;
    }

    public int getTimeMax() {
        IFermentationRecipe result;
        if (!this.field_145850_b.field_72995_K && (result = this.getWorkingRecipe()) != null) {
            return result.getTime();
        }
        return this.timemax;
    }

    private boolean canFerment() {
        if (this.func_70301_a(0) == null) {
            return false;
        }
        if (this.isFluidTankEmpty(0)) {
            return false;
        }
        return this.getWorkingRecipe() != null;
    }

    public void fermentItem() {
        IFermentationRecipe recipe;
        ItemStack fermentItem = this.func_70301_a(0);
        if (fermentItem != null && (recipe = this.getWorkingRecipe()) != null) {
            IMultiItemStacks fermenter;
            FluidStack outputFluidStack = recipe.getOutputFluidStack();
            if (outputFluidStack != null) {
                this.getFluidTank(0).setFluid(FluidUtils.exchangeFluid(this.getFluidStack(0), outputFluidStack.getFluid()));
            }
            if ((fermenter = recipe.getFermentingItemStack()) != null && !fermenter.isEmpty()) {
                this.func_70298_a(0, fermenter.getStackSize());
            }
        }
    }

    @Override
    public float getDeviceProgress() {
        int tmx = this.getTimeMax();
        if (tmx > 0) {
            return (float)this.time / (float)tmx;
        }
        return 0.0f;
    }

    @Override
    public int getDeviceProgressScaled(int scale) {
        int tmx = this.getTimeMax();
        if (tmx > 0) {
            return this.time * scale / tmx;
        }
        return 0;
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            if (this.recheckRecipe) {
                this.recheckRecipe = false;
                this.refreshRecipe();
            }
            if (this.canFerment()) {
                ++this.time;
                if (this.time >= this.getTimeMax()) {
                    this.resetTime();
                    this.fermentItem();
                    this.func_70296_d();
                }
            } else if (this.time != 0) {
                this.resetTime();
                this.func_70296_d();
            }
        }
    }

    @Override
    public int[] func_94128_d(int side) {
        return accessableSlotIds;
    }

    @Override
    public boolean func_94041_b(int index, ItemStack itemstack) {
        return index == 0;
    }

    @Override
    public boolean func_102007_a(int index, ItemStack stack, int side) {
        return InventoryProcessor.instance().canInsertItem((IInventory)this, stack, index);
    }

    @Override
    public boolean func_102008_b(int index, ItemStack stack, int side) {
        return InventoryProcessor.instance().canExtractItem((IInventory)this, stack, index);
    }

    @Override
    protected void readTanksFromNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("Tank")) {
            this.getFluidTank(0).readFromNBT(nbt.func_74775_l("Tank"));
        } else {
            super.readTanksFromNBT(nbt);
        }
    }

    private void readFermentTimeFromNBT(NBTTagCompound nbt) {
        this.time = NBTHelper.getInteger(nbt, "time");
    }

    @Override
    public void readFromNBTForItem(NBTTagCompound nbt) {
        super.readFromNBTForItem(nbt);
        this.readFermentTimeFromNBT(nbt);
        if (nbt.func_74764_b("lid_on")) {
            this.lidOn = nbt.func_74767_n("lid_on");
        }
    }

    @TileEventHandler(event=TileEventHandler.EventType.NBT_READ)
    public void readFromNBT_FermentBarrel(NBTTagCompound nbt) {
        this.readFermentTimeFromNBT(nbt);
    }

    private void writeFermentTimeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("time", this.time);
    }

    @Override
    public void writeToNBTForItem(NBTTagCompound nbt) {
        super.writeToNBTForItem(nbt);
        this.writeFermentTimeToNBT(nbt);
        nbt.func_74757_a("lid_on", this.lidOn);
    }

    @TileEventHandler(event=TileEventHandler.EventType.NBT_WRITE)
    public void writeToNBT_FermentBarrel(NBTTagCompound nbt) {
        this.writeFermentTimeToNBT(nbt);
    }

    @Override
    public void receiveGUINetworkData(int id, int v) {
        super.receiveGUINetworkData(id, v);
        switch (FermentBarrelDataID.getByaOrdinal(id)) {
            case TIME: {
                this.time = v;
                break;
            }
            case TIME_MAX: {
                this.timemax = v;
                break;
            }
        }
    }

    @Override
    public void sendGUINetworkData(Container container, ICrafting iCrafting) {
        super.sendGUINetworkData(container, iCrafting);
        iCrafting.func_71112_a(container, FermentBarrelDataID.TIME.ordinal(), this.time);
        iCrafting.func_71112_a(container, FermentBarrelDataID.TIME_MAX.ordinal(), this.getTimeMax());
    }

    @TileEventHandler(event=TileEventHandler.EventType.NETWORK_READ)
    public boolean readFromStream_FermentBarrel(ByteBuf stream) throws IOException {
        this.time = stream.readInt();
        this.timemax = stream.readInt();
        return false;
    }

    @TileEventHandler(event=TileEventHandler.EventType.NETWORK_WRITE)
    public boolean writeToStream_FermentBarrel(ByteBuf stream) throws IOException {
        stream.writeInt(this.time);
        stream.writeInt(this.getTimeMax());
        return false;
    }

    @Override
    public boolean canFill(ForgeDirection from, Fluid fluid) {
        FluidStack fluidStack = this.getFluidStack(0);
        if (fluidStack == null || fluidStack.getFluid() == null) {
            return true;
        }
        return FluidTest.fluidMatches(fluidStack, fluid);
    }

    @Override
    protected int doFill(ForgeDirection from, FluidStack resource, boolean shouldFill) {
        return this.fillFluidTank(0, resource, shouldFill);
    }

    @Override
    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return FluidTest.fluidMatches(this.getFluidStack(0), fluid);
    }

    @Override
    protected FluidStack doDrain(ForgeDirection from, int maxDrain, boolean shouldDrain) {
        return this.drainFluidTank(0, maxDrain, shouldDrain);
    }

    @Override
    protected FluidStack doDrain(ForgeDirection from, FluidStack resource, boolean shouldDrain) {
        if (resource == null || !resource.isFluidEqual(this.getFluidStack(0))) {
            return null;
        }
        return this.doDrain(from, resource.amount, shouldDrain);
    }

    @Override
    protected void markFluidDirty() {
        super.markFluidDirty();
        this.markForRecipeRecheck();
    }

    @Override
    public void onInventoryChanged(IInventory inv, int index) {
        super.onInventoryChanged(inv, index);
        this.markForRecipeRecheck();
    }

    public static enum FermentBarrelDataID {
        TIME,
        TIME_MAX,
        UNKNOWN;

        public static final FermentBarrelDataID[] VALID;

        public static FermentBarrelDataID getByaOrdinal(int ord) {
            if (ord >= 0 && ord <= VALID.length) {
                return VALID[ord];
            }
            return UNKNOWN;
        }

        static {
            VALID = new FermentBarrelDataID[]{TIME, TIME_MAX};
        }
    }
}

