/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.common.tileentity.device;

import growthcraft.api.cellar.CellarRegistry;
import growthcraft.api.cellar.culturing.ICultureRecipe;
import growthcraft.cellar.common.tileentity.TileEntityCellarDevice;
import growthcraft.cellar.common.tileentity.component.TileHeatingComponent;
import growthcraft.core.common.tileentity.device.DeviceFluidSlot;
import growthcraft.core.common.tileentity.device.DeviceInventorySlot;
import growthcraft.core.common.tileentity.device.DeviceProgressive;
import net.minecraft.inventory.IInventory;

public class CultureGenerator
extends DeviceProgressive {
    protected DeviceFluidSlot fluidSlot;
    protected DeviceInventorySlot invSlot;
    protected TileHeatingComponent heatComponent;

    public CultureGenerator(TileEntityCellarDevice te, TileHeatingComponent heatComp, int fluidSlotIndex, int invSlotIndex) {
        super(te);
        this.heatComponent = heatComp;
        this.fluidSlot = new DeviceFluidSlot(te, fluidSlotIndex);
        this.invSlot = new DeviceInventorySlot((IInventory)te, invSlotIndex);
        this.setTimeMax(1200);
    }

    public float getHeatMultiplier() {
        return this.heatComponent.getHeatMultiplier();
    }

    @Override
    public void increaseTime() {
        ++this.time;
    }

    public boolean isHeated() {
        return this.heatComponent.isHeated();
    }

    private boolean isRecipeValid(ICultureRecipe recipe) {
        if (recipe != null && this.fluidSlot.hasEnough(recipe.getInputFluidStack())) {
            return this.invSlot.isEmpty() || this.invSlot.hasMatchingWithCapacity(recipe.getOutputItemStack());
        }
        return false;
    }

    private void produceCulture(ICultureRecipe recipe) {
        this.fluidSlot.consume(recipe.getInputFluidStack(), true);
        this.invSlot.increaseStack(recipe.getOutputItemStack());
    }

    @Override
    public void update() {
        ICultureRecipe activeRecipe = CellarRegistry.instance().culturing().findRecipe(this.fluidSlot.get(), this.heatComponent.getHeatMultiplier());
        if (this.isRecipeValid(activeRecipe)) {
            this.setTimeMax(activeRecipe.getTime());
            this.increaseTime();
            if (this.time >= this.timeMax) {
                this.resetTime();
                this.produceCulture(activeRecipe);
                this.markDirty();
            }
        } else if (this.resetTime()) {
            this.markDirty();
        }
    }
}

