/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.integration.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import growthcraft.api.cellar.CellarRegistry;
import growthcraft.api.cellar.pressing.PressingRecipe;
import growthcraft.api.core.i18n.GrcI18n;
import growthcraft.cellar.GrowthCraftCellar;
import growthcraft.cellar.client.gui.GuiFruitPress;
import growthcraft.cellar.client.resource.GrcCellarResources;
import growthcraft.core.integration.nei.TemplateRenderHelper;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;

public class RecipeHandlerFruitPress
extends TemplateRecipeHandler {
    public String getGuiTexture() {
        return GrcCellarResources.INSTANCE.textureGuiFruitPress.toString();
    }

    public String getRecipeName() {
        return GrcI18n.translate("grc.recipe_handler.fruit_press");
    }

    @SideOnly(value=Side.CLIENT)
    public Class<? extends GuiContainer> getGuiClass() {
        return GuiFruitPress.class;
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        PressingRecipe recipe = CellarRegistry.instance().pressing().getPressingRecipe(ingredient);
        if (recipe != null) {
            this.arecipes.add(new CachedPressingRecipe(recipe));
        }
    }

    public void drawOutputFluidStack(TemplateRecipeHandler.CachedRecipe recipe) {
        if (recipe instanceof CachedPressingRecipe) {
            PressingRecipe pressingRecipe = ((CachedPressingRecipe)recipe).pressingRecipe;
            TemplateRenderHelper.drawFluidStack(84, 5, 16, 52, pressingRecipe.getFluidStack(), GrowthCraftCellar.getConfig().fruitPressMaxCap);
        }
    }

    public void drawExtras(int recipe) {
        TemplateRecipeHandler.CachedRecipe crecipe = (TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipe);
        if (crecipe != null) {
            this.drawOutputFluidStack(crecipe);
        }
        GuiDraw.changeTexture((String)this.getGuiTexture());
        this.drawProgressBar(58, 24, 176, 0, 25, 16, 40, 0);
    }

    public class CachedPressingRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public PressingRecipe pressingRecipe;
        protected PositionedStack ingredient;
        protected PositionedStack otherStack;

        public CachedPressingRecipe(PressingRecipe recipe) {
            super((TemplateRecipeHandler)RecipeHandlerFruitPress.this);
            this.pressingRecipe = recipe;
            this.ingredient = new PositionedStack(this.pressingRecipe.getInput().getItemStacks(), 40, 24);
            if (recipe.hasResidue()) {
                this.otherStack = new PositionedStack((Object)this.pressingRecipe.getResidue().residueItem, 111, 6);
            }
        }

        public PositionedStack getIngredient() {
            return this.ingredient;
        }

        public PositionedStack getResult() {
            return null;
        }

        public PositionedStack getOtherStack() {
            return this.otherStack;
        }
    }
}

