/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.client.gui.widget;

import growthcraft.api.core.util.Rectangle;
import growthcraft.core.client.gui.widget.Widget;
import growthcraft.core.client.gui.widget.WidgetManager;
import growthcraft.core.common.tileentity.device.IFluidTanks;

public class WidgetFluidTank
extends Widget {
    public final int tankIndex;
    public int numberColor = 0xFFFFFF;
    public Rectangle ruleRect = new Rectangle();

    public WidgetFluidTank(WidgetManager man, int index, int x, int y, int w, int h) {
        super(man, x, y, w, h);
        this.tankIndex = index;
    }

    public WidgetFluidTank setRuleOverlay(int x, int y, int w, int h) {
        this.ruleRect.set(x, y, w, h);
        return this;
    }

    @Override
    protected void doDraw(int mx, int my, int x, int y) {
        Object tileEntity = this.manager.gui.getTileEntity();
        if (tileEntity instanceof IFluidTanks) {
            IFluidTanks tanks = (IFluidTanks)tileEntity;
            int w = this.getWidth();
            int h = this.getHeight();
            if (tanks.getFluidAmountScaled(h, this.tankIndex) > 0) {
                this.manager.gui.drawTank(this.manager.gui.getGuiX(), this.manager.gui.getGuiY(), this.getX(), this.getY(), w, h, tanks.getFluidAmountScaled(h, this.tankIndex), tanks.getFluidStack(this.tankIndex), tanks.getFluidTank(this.tankIndex));
            }
            if (!this.ruleRect.isEmpty()) {
                this.manager.gui.bindGuiTexture();
                this.manager.gui.func_73729_b(x, y, this.ruleRect.x, this.ruleRect.y, this.ruleRect.w, this.ruleRect.h);
            }
        }
    }

    @Override
    protected void doDrawForeground(int mx, int my, int x, int y) {
        IFluidTanks tanks;
        Object tileEntity = this.manager.gui.getTileEntity();
        if (tileEntity instanceof IFluidTanks && !(tanks = (IFluidTanks)tileEntity).isFluidTankEmpty(this.tankIndex)) {
            String s = String.valueOf(tanks.getFluidAmount(this.tankIndex));
            this.manager.gui.getFontRenderer().func_78261_a(s, this.rect.x2() - this.manager.gui.getFontRenderer().func_78256_a(s), this.rect.y2() - 8, this.numberColor);
        }
    }
}

