/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.integration.nei;

import codechicken.nei.NEIClientUtils;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.ShapedRecipeHandler;
import codechicken.nei.recipe.TemplateRecipeHandler;
import growthcraft.api.core.definition.IMultiFluidStacks;
import growthcraft.api.core.definition.IMultiItemStacks;
import growthcraft.api.core.fluids.FluidUtils;
import growthcraft.api.core.item.recipes.ShapelessMultiRecipe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;

public class RecipeHandlerShapelessMulti
extends ShapedRecipeHandler {
    public int[][] stackorder = new int[][]{{0, 0}, {1, 0}, {0, 1}, {1, 1}, {0, 2}, {1, 2}, {2, 0}, {2, 1}, {2, 2}};

    public String getRecipeName() {
        return NEIClientUtils.translate((String)"recipe.shapeless", (Object[])new Object[0]);
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("crafting") && ((Object)((Object)this)).getClass() == RecipeHandlerShapelessMulti.class) {
            List allrecipes = CraftingManager.func_77594_a().func_77592_b();
            for (IRecipe irecipe : allrecipes) {
                List<CachedShapelessMultiRecipe> recipes = null;
                if (irecipe instanceof ShapelessMultiRecipe) {
                    recipes = this.shapelessMultiRecipe((ShapelessMultiRecipe)irecipe);
                }
                if (recipes == null) continue;
                for (CachedShapelessMultiRecipe cRecipe : recipes) {
                    this.arecipes.add(cRecipe);
                }
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        List allrecipes = CraftingManager.func_77594_a().func_77592_b();
        for (IRecipe irecipe : allrecipes) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)irecipe.func_77571_b(), (ItemStack)result)) continue;
            List<CachedShapelessMultiRecipe> recipes = null;
            if (irecipe instanceof ShapelessMultiRecipe) {
                recipes = this.shapelessMultiRecipe((ShapelessMultiRecipe)irecipe);
            }
            if (recipes == null) continue;
            for (CachedShapelessMultiRecipe cRecipe : recipes) {
                this.arecipes.add(cRecipe);
            }
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        List allrecipes = CraftingManager.func_77594_a().func_77592_b();
        for (IRecipe irecipe : allrecipes) {
            List<CachedShapelessMultiRecipe> recipes = null;
            if (irecipe instanceof ShapelessMultiRecipe) {
                recipes = this.shapelessMultiRecipe((ShapelessMultiRecipe)irecipe);
            }
            if (recipes == null) continue;
            for (CachedShapelessMultiRecipe cRecipe : recipes) {
                if (!cRecipe.contains(cRecipe.ingredients, ingredient)) continue;
                cRecipe.setIngredientPermutation(cRecipe.ingredients, ingredient);
                this.arecipes.add(cRecipe);
            }
        }
    }

    public List<CachedShapelessMultiRecipe> shapelessMultiRecipe(ShapelessMultiRecipe multiRecipe) {
        ArrayList<List<ItemStack>> items = new ArrayList<List<ItemStack>>();
        List<IMultiFluidStacks> fluidStacks = multiRecipe.getFluids();
        ArrayList<CachedShapelessMultiRecipe> cachedRecipes = new ArrayList<CachedShapelessMultiRecipe>();
        for (IMultiItemStacks item : multiRecipe.getInput()) {
            if (item.isEmpty()) {
                return null;
            }
            items.add(item.getItemStacks());
        }
        ArrayList<ArrayList<List<ItemStack>>> recipes = new ArrayList<ArrayList<List<ItemStack>>>();
        recipes.add(items);
        for (IMultiFluidStacks iMultiFluidStacks : fluidStacks) {
            ArrayList recipesFluidStacks = new ArrayList();
            HashMap itemsFluidMap = new HashMap();
            for (FluidStack fluidStack : iMultiFluidStacks.getFluidStacks()) {
                List<FluidContainerRegistry.FluidContainerData> fluidData = FluidUtils.getFluidData().get(fluidStack.getFluid());
                if (fluidData == null) continue;
                for (FluidContainerRegistry.FluidContainerData fluidContainerData : fluidData) {
                    FluidStack fluid = fluidContainerData.fluid;
                    int amount = (int)Math.max(1.0, Math.ceil(((double)iMultiFluidStacks.getAmount() - 1.0) / (double)fluid.amount));
                    if (!itemsFluidMap.containsKey(amount)) {
                        itemsFluidMap.put(amount, new ArrayList());
                    }
                    ((ArrayList)itemsFluidMap.get(amount)).add(fluidContainerData.filledContainer);
                }
            }
            for (Map.Entry entry : itemsFluidMap.entrySet()) {
                ArrayList itemFluid = new ArrayList();
                for (int i = 0; i < (Integer)entry.getKey(); ++i) {
                    itemFluid.add(entry.getValue());
                }
                for (ArrayList arrayList : recipes) {
                    ArrayList recipeCopy = new ArrayList(arrayList);
                    recipeCopy.addAll(itemFluid);
                    recipesFluidStacks.add(recipeCopy);
                }
            }
            if (recipesFluidStacks.size() == 0) {
                return cachedRecipes;
            }
            recipes = recipesFluidStacks;
        }
        for (ArrayList arrayList : recipes) {
            if (arrayList.size() > 9) continue;
            cachedRecipes.add(new CachedShapelessMultiRecipe(arrayList, multiRecipe.func_77571_b()));
        }
        return cachedRecipes;
    }

    public boolean isRecipe2x2(int recipe) {
        return this.getIngredientStacks(recipe).size() <= 4;
    }

    public class CachedShapelessMultiRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public ArrayList<PositionedStack> ingredients;
        public PositionedStack result;

        public CachedShapelessMultiRecipe() {
            super((TemplateRecipeHandler)RecipeHandlerShapelessMulti.this);
            this.ingredients = new ArrayList();
        }

        public CachedShapelessMultiRecipe(ItemStack output) {
            this();
            this.setResult(output);
        }

        public CachedShapelessMultiRecipe(Object[] input, ItemStack output) {
            this(Arrays.asList(input), output);
        }

        public CachedShapelessMultiRecipe(List<?> input, ItemStack output) {
            this(output);
            this.setIngredients(input);
        }

        public void setIngredients(List<?> items) {
            this.ingredients.clear();
            for (int ingred = 0; ingred < items.size(); ++ingred) {
                PositionedStack stack = new PositionedStack(items.get(ingred), 25 + RecipeHandlerShapelessMulti.this.stackorder[ingred][0] * 18, 6 + RecipeHandlerShapelessMulti.this.stackorder[ingred][1] * 18);
                stack.setMaxSize(1);
                this.ingredients.add(stack);
            }
        }

        public void setResult(ItemStack output) {
            this.result = new PositionedStack((Object)output, 119, 24);
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(RecipeHandlerShapelessMulti.this.cycleticks / 20, this.ingredients);
        }

        public PositionedStack getResult() {
            return this.result;
        }
    }
}

