/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.integration.waila;

import cpw.mods.fml.common.Optional;
import growthcraft.api.core.i18n.GrcI18n;
import growthcraft.api.core.nbt.NBTHelper;
import growthcraft.core.common.tileentity.feature.ITileHeatedDevice;
import growthcraft.core.common.tileentity.feature.ITileNamedFluidTanks;
import growthcraft.core.common.tileentity.feature.ITileProgressiveDevice;
import growthcraft.core.util.TagFormatterFluidHandler;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fluids.IFluidHandler;

public class CoreDataProvider
implements IWailaDataProvider {
    @Optional.Method(modid="Waila")
    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return accessor.getStack();
    }

    @Optional.Method(modid="Waila")
    public List<String> getWailaHead(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return tooltip;
    }

    @Optional.Method(modid="Waila")
    public List<String> getWailaBody(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        float prog;
        Block block = accessor.getBlock();
        TileEntity te = accessor.getTileEntity();
        NBTTagCompound tag = accessor.getNBTData();
        if (config.getConfig("DisplayFluidContent") && te instanceof IFluidHandler) {
            tooltip = TagFormatterFluidHandler.INSTANCE.format(tooltip, tag);
        }
        if (te instanceof ITileHeatedDevice) {
            boolean isHeated = tag.func_74767_n("is_heated");
            float heat = tag.func_74760_g("heat_multiplier");
            String result = EnumChatFormatting.GRAY + GrcI18n.translate("grccore.device.heated.prefix");
            result = isHeated ? result + EnumChatFormatting.WHITE + GrcI18n.translate("grccore.device.heated.multiplier.format", (int)(heat * 100.0f)) : result + EnumChatFormatting.WHITE + GrcI18n.translate("grccore.device.heated.state.false");
            tooltip.add(result);
        }
        if (te instanceof ITileProgressiveDevice && (prog = tag.func_74760_g("device_progress")) > 0.0f) {
            String result = EnumChatFormatting.GRAY + GrcI18n.translate("grccore.device.progress.prefix") + EnumChatFormatting.WHITE + GrcI18n.translate("grccore.device.progress.format", (int)(prog * 100.0f));
            tooltip.add(result);
        }
        return tooltip;
    }

    @Optional.Method(modid="Waila")
    public List<String> getWailaTail(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return tooltip;
    }

    @Optional.Method(modid="Waila")
    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, int x, int y, int z) {
        Object device;
        if (te instanceof IFluidHandler) {
            NBTHelper.writeIFluidHandlerToNBT((IFluidHandler)te, tag);
        }
        if (te instanceof ITileNamedFluidTanks) {
            ((ITileNamedFluidTanks)te).writeFluidTankNamesToTag(tag);
        }
        if (te instanceof ITileProgressiveDevice) {
            device = (ITileProgressiveDevice)te;
            tag.func_74776_a("device_progress", device.getDeviceProgress());
        }
        if (te instanceof ITileHeatedDevice) {
            device = (ITileHeatedDevice)te;
            tag.func_74757_a("is_heated", device.isHeated());
            tag.func_74776_a("heat_multiplier", device.getHeatMultiplier());
        }
        return tag;
    }
}

