/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.fishtrap.common.tileentity;

import growthcraft.api.core.nbt.NBTType;
import growthcraft.api.fishtrap.BaitRegistry;
import growthcraft.api.fishtrap.FishTrapRegistry;
import growthcraft.core.common.inventory.GrcInternalInventory;
import growthcraft.core.common.inventory.InventoryProcessor;
import growthcraft.core.common.inventory.InventorySlice;
import growthcraft.core.common.tileentity.GrcTileInventoryBase;
import growthcraft.core.common.tileentity.feature.IInteractionObject;
import growthcraft.fishtrap.common.inventory.ContainerFishTrap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class TileEntityFishTrap
extends GrcTileInventoryBase
implements IInteractionObject {
    private static final int[] TRAP_SLOTS = new int[]{0, 1, 2, 3, 4, 5};
    private static final int[] BAIT_SLOTS = new int[]{6};
    private static final int[] ACCESSIBLE_SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6};
    public InventorySlice trapInventory = new InventorySlice((IInventory)this, TRAP_SLOTS);
    public InventorySlice baitInventory = new InventorySlice((IInventory)this, BAIT_SLOTS);

    @Override
    public String getGuiID() {
        return "grcfishtrap:fish_trap";
    }

    @Override
    public Container createContainer(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerFishTrap(playerInventory, this);
    }

    @Override
    public GrcInternalInventory createInventory() {
        return new GrcInternalInventory(this, 7);
    }

    @Override
    public boolean func_102007_a(int slot, ItemStack stack, int facing) {
        if (slot == 6) {
            return super.func_102007_a(slot, stack, facing);
        }
        return false;
    }

    @Override
    public boolean func_102008_b(int slot, ItemStack stack, int facing) {
        if (slot < 6) {
            return super.func_102008_b(slot, stack, facing);
        }
        return false;
    }

    @Override
    public int[] func_94128_d(int facing) {
        return ACCESSIBLE_SLOTS;
    }

    public void consumeBait() {
        this.baitInventory.func_70298_a(0, 1);
    }

    public float applyBaitModifier(float f) {
        BaitRegistry.BaitHandle handle;
        float result = f;
        ItemStack bait = this.baitInventory.func_70301_a(0);
        if (bait != null && (handle = FishTrapRegistry.instance().findBait(bait)) != null) {
            result += handle.baseRate;
            result *= handle.multiplier;
        }
        return result;
    }

    public int getBaitInventoryOffset() {
        return BAIT_SLOTS[0];
    }

    public int getTrapInventorySize() {
        return TRAP_SLOTS.length;
    }

    public int getBaitInventorySize() {
        return BAIT_SLOTS.length;
    }

    public boolean canUpdate() {
        return false;
    }

    public boolean addStack(ItemStack stack) {
        return InventoryProcessor.instance().mergeWithSlots(this.trapInventory, stack);
    }

    @Override
    public String getDefaultInventoryName() {
        return "container.grc.fishTrap";
    }

    @Override
    protected void readInventoryFromNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("items")) {
            this.inventory.clear();
            NBTTagList tags = nbt.func_150295_c("items", NBTType.COMPOUND.id);
            for (int i = 0; i < tags.func_74745_c(); ++i) {
                NBTTagCompound item = tags.func_150305_b(i);
                byte b0 = item.func_74771_c("Slot");
                if (b0 < 0 || b0 >= this.trapInventory.func_70302_i_()) continue;
                ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)item);
                InventoryProcessor.instance().mergeWithSlot(this.trapInventory, stack, b0);
            }
        } else {
            super.readInventoryFromNBT(nbt);
        }
    }
}

