/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.milk.common.item;

import growthcraft.api.core.nbt.NBTHelper;
import growthcraft.core.common.item.IItemTileBlock;
import growthcraft.milk.common.item.EnumCheeseStage;
import growthcraft.milk.common.item.EnumCheeseType;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class ItemBlockCheeseBlock
extends ItemBlock
implements IItemTileBlock {
    public ItemBlockCheeseBlock(Block block) {
        super(block);
        this.field_77777_bU = 1;
    }

    private NBTTagCompound getTileTagCompoundABS(ItemStack stack) {
        NBTTagCompound tag = NBTHelper.openItemStackTag(stack);
        if (!tag.func_74764_b("te_cheese_block")) {
            NBTTagCompound cheeseTag = new NBTTagCompound();
            EnumCheeseType cheese = EnumCheeseType.getSafeById(stack.func_77960_j());
            cheese.writeToNBT(cheeseTag);
            cheese.stages.get(0).writeToNBT(cheeseTag);
            tag.func_74782_a("te_cheese_block", (NBTBase)cheeseTag);
        }
        return tag.func_74775_l("te_cheese_block");
    }

    @Override
    public void setTileTagCompound(ItemStack stack, NBTTagCompound tileTag) {
        NBTTagCompound tag = NBTHelper.openItemStackTag(stack);
        tag.func_74782_a("te_cheese_block", (NBTBase)tileTag);
    }

    @Override
    public NBTTagCompound getTileTagCompound(ItemStack stack) {
        NBTTagCompound tag = this.getTileTagCompoundABS(stack);
        EnumCheeseType type = this.getCheeseType(stack);
        if (stack.func_77960_j() != type.meta) {
            stack.func_77964_b(type.meta);
        }
        return tag;
    }

    public EnumCheeseType getCheeseType(ItemStack stack) {
        NBTTagCompound tag = this.getTileTagCompoundABS(stack);
        return EnumCheeseType.loadFromNBT(tag);
    }

    public EnumCheeseStage getCheeseStage(ItemStack stack) {
        NBTTagCompound tag = this.getTileTagCompoundABS(stack);
        return EnumCheeseStage.loadFromNBT(tag);
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77667_c(stack) + "." + this.getCheeseType((ItemStack)stack).name + "." + this.getCheeseStage((ItemStack)stack).name;
    }

    public int getSlices(ItemStack stack) {
        return this.getTileTagCompound(stack).func_74762_e("slices");
    }

    public int getSlicesMax(ItemStack stack) {
        return this.getTileTagCompound(stack).func_74762_e("slices_max");
    }

    public static NBTTagCompound openNBT(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof ItemBlockCheeseBlock) {
            return ((ItemBlockCheeseBlock)item).getTileTagCompound(stack);
        }
        return null;
    }
}

