/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.milk.common.struct;

import growthcraft.api.core.nbt.INBTSerializableContext;
import growthcraft.api.core.stream.IStreamable;
import growthcraft.milk.common.item.EnumCheeseType;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class CheeseCurd
implements INBTSerializableContext,
IStreamable {
    public boolean needClientUpdate;
    private EnumCheeseType cheese = EnumCheeseType.CHEDDAR;
    private int age;
    private int ageMax = 1200;
    private boolean dried;

    public EnumCheeseType getType() {
        return this.cheese;
    }

    public int getId() {
        return this.cheese.meta;
    }

    public float getAgeProgress() {
        return (float)this.age / (float)this.ageMax;
    }

    public int getRenderColor() {
        return this.cheese.getColor();
    }

    public boolean isDried() {
        return this.dried;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        this.cheese.writeToNBT(nbt);
        nbt.func_74757_a("dried", this.dried);
        nbt.func_74768_a("age", this.age);
        nbt.func_74768_a("age_max", this.ageMax);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, String name) {
        NBTTagCompound target = new NBTTagCompound();
        this.writeToNBT(target);
        nbt.func_74782_a(name, (NBTBase)target);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.cheese = EnumCheeseType.loadFromNBT(nbt);
        this.dried = nbt.func_74767_n("dried");
        this.age = nbt.func_74762_e("age");
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, String name) {
        if (nbt.func_74764_b(name)) {
            this.readFromNBT(nbt.func_74775_l(name));
        }
    }

    @Override
    public boolean readFromStream(ByteBuf stream) {
        this.cheese = EnumCheeseType.loadFromStream(stream);
        this.dried = stream.readBoolean();
        this.age = stream.readInt();
        return false;
    }

    @Override
    public boolean writeToStream(ByteBuf stream) {
        this.cheese.writeToStream(stream);
        stream.writeBoolean(this.dried);
        stream.writeInt(this.age);
        return false;
    }

    public void update() {
        if (this.dried) {
            if (this.age != this.ageMax) {
                this.age = this.ageMax;
                this.needClientUpdate = true;
            }
        } else if (this.age < this.ageMax) {
            ++this.age;
        } else {
            this.dried = true;
            this.needClientUpdate = true;
        }
    }
}

