/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.milk.common.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import growthcraft.api.core.item.ItemTest;
import growthcraft.api.milk.MilkRegistry;
import growthcraft.api.milk.cheesepress.ICheesePressRecipe;
import growthcraft.core.common.inventory.GrcInternalInventory;
import growthcraft.core.common.tileentity.GrcTileInventoryBase;
import growthcraft.core.common.tileentity.device.DeviceInventorySlot;
import growthcraft.core.common.tileentity.event.TileEventHandler;
import growthcraft.core.common.tileentity.feature.IItemHandler;
import growthcraft.core.common.tileentity.feature.ITileProgressiveDevice;
import growthcraft.core.util.ItemUtils;
import growthcraft.milk.GrowthCraftMilk;
import growthcraft.milk.common.item.ItemBlockHangingCurds;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;

public class TileEntityCheesePress
extends GrcTileInventoryBase
implements IItemHandler,
ITileProgressiveDevice {
    private static int[][] accessibleSlots = new int[][]{{0}, {0}, {0}, {0}, {0}, {0}};
    @SideOnly(value=Side.CLIENT)
    public float animProgress;
    @SideOnly(value=Side.CLIENT)
    public int animDir;
    private int screwState;
    private DeviceInventorySlot invSlot = new DeviceInventorySlot((IInventory)this, 0);
    private int time;
    private boolean needRecipeRecheck = true;
    private ICheesePressRecipe workingRecipe;

    public void markForRecipeCheck() {
        this.needRecipeRecheck = true;
    }

    private void setupWorkingRecipe() {
        ICheesePressRecipe recipe = MilkRegistry.instance().cheesePress().findRecipe(this.invSlot.get());
        if (recipe != this.workingRecipe) {
            if (this.workingRecipe != null) {
                this.time = 0;
            }
            this.workingRecipe = recipe;
        }
    }

    protected ICheesePressRecipe getWorkingRecipe() {
        if (this.workingRecipe == null) {
            this.setupWorkingRecipe();
        }
        return this.workingRecipe;
    }

    @Override
    public float getDeviceProgress() {
        ICheesePressRecipe recipe = this.getWorkingRecipe();
        if (recipe != null) {
            return (float)this.time / (float)recipe.getTimeMax();
        }
        return 0.0f;
    }

    @Override
    public int getDeviceProgressScaled(int scale) {
        ICheesePressRecipe recipe = this.getWorkingRecipe();
        if (recipe != null) {
            return this.time * scale / recipe.getTimeMax();
        }
        return 0;
    }

    public boolean isPressed() {
        return this.screwState == 1;
    }

    public boolean isUnpressed() {
        return this.screwState == 0;
    }

    @Override
    public void onInventoryChanged(IInventory inv, int index) {
        super.onInventoryChanged(inv, index);
        this.markForRecipeCheck();
    }

    @Override
    public GrcInternalInventory createInventory() {
        return new GrcInternalInventory(this, 1, 1);
    }

    @Override
    public String getDefaultInventoryName() {
        return "container.grcmilk.CheesePress";
    }

    @Override
    public boolean func_94041_b(int index, ItemStack itemstack) {
        return true;
    }

    @Override
    public int[] func_94128_d(int side) {
        return accessibleSlots[side];
    }

    @Override
    public boolean func_102007_a(int index, ItemStack stack, int side) {
        return this.isUnpressed() && index == 0;
    }

    @Override
    public boolean func_102008_b(int index, ItemStack stack, int side) {
        return this.isUnpressed() && index == 0;
    }

    @SideOnly(value=Side.CLIENT)
    private void updateEntityClient() {
        float step = 0.05f;
        this.animDir = this.isUnpressed() ? -1 : 1;
        if (this.animDir > 0 && this.animProgress < 1.0f || this.animDir < 0 && this.animProgress > 0.0f) {
            this.animProgress = MathHelper.func_76131_a((float)(this.animProgress + 0.05f * (float)this.animDir), (float)0.0f, (float)1.0f);
        }
    }

    private void commitRecipe() {
        ICheesePressRecipe recipe = this.getWorkingRecipe();
        if (recipe != null) {
            this.invSlot.set(recipe.getOutputItemStack().func_77946_l());
            this.workingRecipe = null;
        }
    }

    private void updateEntityServer() {
        ICheesePressRecipe recipe;
        if (this.needRecipeRecheck) {
            this.needRecipeRecheck = false;
            this.setupWorkingRecipe();
        }
        if ((recipe = this.getWorkingRecipe()) != null) {
            if (this.isPressed()) {
                if (this.time < recipe.getTimeMax()) {
                    ++this.time;
                } else {
                    this.time = 0;
                    this.commitRecipe();
                }
            } else if (this.time > 0) {
                --this.time;
            }
        } else if (this.time != 0) {
            this.time = 0;
            this.func_70296_d();
        }
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            this.updateEntityClient();
        } else {
            this.updateEntityServer();
        }
    }

    public boolean toggle(boolean state) {
        int oldScrewState = this.screwState;
        int n = this.screwState = state ? 1 : 0;
        if (oldScrewState != this.screwState) {
            this.markForUpdate();
        }
        return oldScrewState != this.screwState;
    }

    public boolean toggle() {
        return this.toggle(this.screwState == 0);
    }

    @Override
    public boolean tryPlaceItem(IItemHandler.Action action, EntityPlayer player, ItemStack stack) {
        ItemBlockHangingCurds item;
        if (IItemHandler.Action.RIGHT != action) {
            return false;
        }
        if (ItemTest.isValid(stack) && this.invSlot.isEmpty() && this.isUnpressed() && GrowthCraftMilk.blocks.hangingCurds.getItem() == stack.func_77973_b() && (item = (ItemBlockHangingCurds)stack.func_77973_b()).isDried(stack)) {
            ItemStack result = ItemUtils.decrPlayerCurrentInventorySlot(player, 1);
            this.invSlot.set(result);
            return true;
        }
        return false;
    }

    @Override
    public boolean tryTakeItem(IItemHandler.Action action, EntityPlayer player, ItemStack onHand) {
        ItemStack result;
        if (IItemHandler.Action.LEFT != action) {
            return false;
        }
        if (this.isUnpressed() && (result = this.invSlot.yank()) != null) {
            ItemUtils.spawnItemStackAtTile(result, this, this.field_145850_b.field_73012_v);
            return true;
        }
        return false;
    }

    @TileEventHandler(event=TileEventHandler.EventType.NBT_READ)
    public void readFromNBT_CheesePress(NBTTagCompound nbt) {
        this.screwState = nbt.func_74762_e("screw_state");
        this.time = nbt.func_74762_e("time");
    }

    @TileEventHandler(event=TileEventHandler.EventType.NBT_WRITE)
    public void writeToNBT_CheesePress(NBTTagCompound nbt) {
        nbt.func_74768_a("screw_state", this.screwState);
        nbt.func_74768_a("time", this.time);
    }

    @TileEventHandler(event=TileEventHandler.EventType.NETWORK_READ)
    public boolean readFromStream_CheesePress(ByteBuf stream) throws IOException {
        this.screwState = stream.readInt();
        this.time = stream.readInt();
        return false;
    }

    @TileEventHandler(event=TileEventHandler.EventType.NETWORK_WRITE)
    public boolean writeToStream_CheesePress(ByteBuf stream) throws IOException {
        stream.writeInt(this.screwState);
        stream.writeInt(this.time);
        return false;
    }
}

