/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.milk.common.world;

import cpw.mods.fml.common.IWorldGenerator;
import growthcraft.api.core.util.BiomeUtils;
import growthcraft.milk.GrowthCraftMilk;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGeneratorThistle
implements IWorldGenerator {
    private WorldGenerator thistle;

    private boolean canPlaceOnBlock(World world, int x, int y, int z, Block block) {
        return Blocks.field_150346_d.equals(block) || Blocks.field_150349_c.equals(block);
    }

    private boolean canReplaceBlock(World world, int x, int y, int z, Block block) {
        return block.isAir((IBlockAccess)world, x, y, z) || block.isLeaves((IBlockAccess)world, x, y, z) || Blocks.field_150395_bd == block;
    }

    private void genRandThistle(WorldGenerator generator, World world, Random rand, int chunk_x, int chunk_z, int maxToSpawn, int minHeight, int maxHeight) {
        int genChance = GrowthCraftMilk.getConfig().thistleGenChance;
        for (int i = 0; i < maxToSpawn; ++i) {
            Block block;
            int y;
            if (genChance > 0 && rand.nextInt(genChance) != 0) continue;
            int x = chunk_x * 16 + rand.nextInt(16);
            int z = chunk_z * 16 + rand.nextInt(16);
            for (y = maxHeight; y > minHeight; --y) {
                if (this.canReplaceBlock(world, x, y, z, world.func_147439_a(x, y, z))) continue;
                ++y;
                break;
            }
            if (y <= minHeight || !this.canPlaceOnBlock(world, x, y - 1, z, block = world.func_147439_a(x, y - 1, z))) continue;
            world.func_147449_b(x, y, z, GrowthCraftMilk.blocks.thistle.getBlock());
        }
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.field_76574_g == 0) {
            String biomeId;
            BiomeGenBase biome = world.func_72807_a(chunkX, chunkZ);
            if (GrowthCraftMilk.getConfig().thistleUseBiomeDict ? !BiomeUtils.testBiomeTypeTagsTable(biome, GrowthCraftMilk.getConfig().thistleBiomesTypeList) : !BiomeUtils.testBiomeIdTags(biomeId = "" + biome.field_76756_M, GrowthCraftMilk.getConfig().thistleBiomesIdList)) {
                return;
            }
            this.genRandThistle(this.thistle, world, random, chunkX, chunkZ, GrowthCraftMilk.getConfig().thistleGenAmount, 64, 255);
        }
    }
}

