/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.general.gui.frame;

import java.util.List;
import net.machinemuse.general.gui.frame.IGuiFrame;
import net.machinemuse.numina.general.MuseMathUtils;
import net.machinemuse.numina.geometry.Colour;
import net.machinemuse.numina.geometry.DrawableMuseRect;
import net.machinemuse.numina.geometry.MusePoint2D;
import net.machinemuse.numina.render.RenderState;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class ScrollableFrame
implements IGuiFrame {
    protected int totalsize;
    protected int currentscrollpixels;
    protected final int buttonsize = 5;
    protected boolean scrollbarPicked = false;
    protected boolean scrolldownPicked = false;
    protected boolean scrollupPicked = false;
    protected int lastdWheel = Mouse.getDWheel();
    protected DrawableMuseRect border;

    public ScrollableFrame(MusePoint2D topleft, MusePoint2D bottomright, Colour borderColour, Colour insideColour) {
        this.border = new DrawableMuseRect(topleft, bottomright, borderColour, insideColour);
    }

    protected double getScrollAmount() {
        return 8.0;
    }

    @Override
    public void update(double x, double y) {
        if (this.border.containsPoint(x, y)) {
            int dscroll = (this.lastdWheel - Mouse.getDWheel()) / 15;
            this.lastdWheel = Mouse.getDWheel();
            if (Mouse.isButtonDown((int)0)) {
                if (y - this.border.top() < 5.0 && this.currentscrollpixels > 0) {
                    dscroll = (int)((double)dscroll - this.getScrollAmount());
                } else if (this.border.bottom() - y < 5.0) {
                    dscroll = (int)((double)dscroll + this.getScrollAmount());
                }
            }
            this.currentscrollpixels = (int)MuseMathUtils.clampDouble((double)(this.currentscrollpixels + dscroll), (double)0.0, (double)this.getMaxScrollPixels());
        }
    }

    public void preDraw() {
        this.border.draw();
        RenderState.glowOn();
        RenderState.texturelessOn();
        GL11.glBegin((int)4);
        Colour.LIGHTBLUE.doGL();
        if ((double)this.currentscrollpixels + this.border.height() < (double)this.totalsize) {
            GL11.glVertex3d((double)(this.border.left() + this.border.width() / 2.0), (double)this.border.bottom(), (double)1.0);
            GL11.glVertex3d((double)(this.border.left() + this.border.width() / 2.0 + 2.0), (double)(this.border.bottom() - 4.0), (double)1.0);
            GL11.glVertex3d((double)(this.border.left() + this.border.width() / 2.0 - 2.0), (double)(this.border.bottom() - 4.0), (double)1.0);
        }
        if (this.currentscrollpixels > 0) {
            GL11.glVertex3d((double)(this.border.left() + this.border.width() / 2.0), (double)this.border.top(), (double)1.0);
            GL11.glVertex3d((double)(this.border.left() + this.border.width() / 2.0 - 2.0), (double)(this.border.top() + 4.0), (double)1.0);
            GL11.glVertex3d((double)(this.border.left() + this.border.width() / 2.0 + 2.0), (double)(this.border.top() + 4.0), (double)1.0);
        }
        Colour.WHITE.doGL();
        GL11.glEnd();
        RenderState.texturelessOff();
        RenderState.scissorsOn((double)(this.border.left() + 4.0), (double)(this.border.top() + 4.0), (double)(this.border.width() - 8.0), (double)(this.border.height() - 8.0));
    }

    public void postDraw() {
        RenderState.scissorsOff();
        RenderState.glowOff();
    }

    @Override
    public void draw() {
        this.preDraw();
        this.postDraw();
    }

    @Override
    public void onMouseDown(double x, double y, int button) {
    }

    @Override
    public void onMouseUp(double x, double y, int button) {
    }

    public int getMaxScrollPixels() {
        return (int)Math.max((double)this.totalsize - this.border.height(), 0.0);
    }

    @Override
    public List<String> getToolTip(int x, int y) {
        return null;
    }
}

