/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.event;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Objects;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.general.gui.EnergyMeter;
import net.machinemuse.general.gui.HeatMeter;
import net.machinemuse.general.gui.WaterMeter;
import net.machinemuse.general.gui.clickable.ClickableKeybinding;
import net.machinemuse.numina.network.MusePacket;
import net.machinemuse.numina.network.PacketSender;
import net.machinemuse.powersuits.common.Config;
import net.machinemuse.powersuits.control.KeybindManager;
import net.machinemuse.powersuits.control.PlayerInputMap;
import net.machinemuse.powersuits.item.ItemPowerArmorChestplate;
import net.machinemuse.powersuits.item.ItemPowerArmorHelmet;
import net.machinemuse.powersuits.network.packets.MusePacketPlayerUpdate;
import net.machinemuse.utils.AddonWaterUtils;
import net.machinemuse.utils.ElectricItemUtils;
import net.machinemuse.utils.MuseHeatUtils;
import net.machinemuse.utils.MuseItemUtils;
import net.machinemuse.utils.MuseStringUtils;
import net.machinemuse.utils.render.MuseRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class ClientTickHandler {
    public ArrayList<String> modules;
    private boolean drawWaterMeter = false;
    protected HeatMeter heat = null;
    protected HeatMeter energy = null;
    protected WaterMeter water = null;

    @SubscribeEvent
    public void onPreClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            for (ClickableKeybinding kb : KeybindManager.getKeybindings()) {
                kb.doToggleTick();
            }
        } else {
            EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
            if (player != null && MuseItemUtils.getModularItemsInInventory((EntityPlayer)player).size() > 0) {
                PlayerInputMap inputmap = PlayerInputMap.getInputMapFor(player.func_70005_c_());
                inputmap.forwardKey = Math.signum(player.field_71158_b.field_78900_b);
                inputmap.strafeKey = Math.signum(player.field_71158_b.field_78902_a);
                inputmap.jumpKey = player.field_71158_b.field_78901_c;
                inputmap.sneakKey = player.field_71158_b.field_78899_d;
                inputmap.motionX = player.field_70159_w;
                inputmap.motionY = player.field_70181_x;
                inputmap.motionZ = player.field_70179_y;
                if (inputmap.hasChanged()) {
                    inputmap.refresh();
                    MusePacketPlayerUpdate inputPacket = new MusePacketPlayerUpdate((EntityPlayer)player, inputmap);
                    PacketSender.sendToServer((MusePacket)inputPacket);
                }
            }
        }
    }

    public void findInstalledModules(EntityPlayer player) {
        if (player != null) {
            ItemStack chest;
            ItemStack tool = player.func_71045_bC();
            ItemStack helmet = player.func_82169_q(3);
            if (helmet != null && helmet.func_77973_b() instanceof ItemPowerArmorHelmet) {
                if (ModuleManager.itemHasActiveModule(helmet, "Auto-Feeder")) {
                    this.modules.add("Auto-Feeder");
                }
                if (ModuleManager.itemHasActiveModule(helmet, "Clock")) {
                    this.modules.add("Clock");
                }
                if (ModuleManager.itemHasActiveModule(helmet, "Compass")) {
                    this.modules.add("Compass");
                }
            }
            if ((chest = player.func_82169_q(2)) != null && chest.func_77973_b() instanceof ItemPowerArmorChestplate && ModuleManager.itemHasActiveModule(chest, "Water Tank")) {
                this.modules.add("Water Tank");
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onRenderTickEvent(TickEvent.RenderTickEvent event) {
        int yBaseString;
        double yBaseIcon;
        ItemStack food = new ItemStack(Items.field_151083_be);
        ItemStack clock = new ItemStack(Items.field_151113_aN);
        ItemStack compass = new ItemStack(Items.field_151111_aL);
        int yOffsetString = 18;
        double yOffsetIcon = 16.0;
        String ampm = "";
        if (Config.useGraphicalMeters()) {
            yBaseIcon = 150.0;
            yBaseString = 155;
        } else {
            yBaseIcon = 26.0;
            yBaseString = 32;
        }
        if (event.phase == TickEvent.Phase.END) {
            EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
            this.modules = new ArrayList();
            this.findInstalledModules((EntityPlayer)player);
            if (player != null && MuseItemUtils.modularItemsEquipped((EntityPlayer)player).size() > 0 && Minecraft.func_71410_x().field_71462_r == null) {
                Minecraft mc = Minecraft.func_71410_x();
                ScaledResolution screen = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
                for (int i = 0; i < this.modules.size(); ++i) {
                    if (Objects.equals(this.modules.get(i), "Auto-Feeder")) {
                        int foodLevel = (int)MuseItemUtils.getFoodLevel(player.func_82169_q(3));
                        String num = MuseStringUtils.formatNumberShort(foodLevel);
                        if (i == 0) {
                            MuseRenderer.drawString(num, 17.0, yBaseString);
                            MuseRenderer.drawItemAt(-1.0, yBaseIcon, food);
                            continue;
                        }
                        MuseRenderer.drawString(num, 17.0, yBaseString + yOffsetString * i);
                        MuseRenderer.drawItemAt(-1.0, yBaseIcon + yOffsetIcon * (double)i, food);
                        continue;
                    }
                    if (Objects.equals(this.modules.get(i), "Clock")) {
                        long time = player.field_70170_p.field_73011_w.getWorldTime();
                        long hour = time % 24000L / 1000L;
                        if (Config.use24hClock()) {
                            hour = hour < 19L ? (hour += 6L) : (hour -= 18L);
                            ampm = "h";
                        } else if (hour < 6L) {
                            hour += 6L;
                            ampm = " AM";
                        } else if (hour == 6L) {
                            hour = 12L;
                            ampm = " PM";
                        } else if (hour > 6L && hour < 18L) {
                            hour -= 6L;
                            ampm = " PM";
                        } else if (hour == 18L) {
                            hour = 12L;
                            ampm = " AM";
                        } else {
                            hour -= 18L;
                            ampm = " AM";
                        }
                        if (i == 0) {
                            MuseRenderer.drawString(hour + ampm, 17.0, yBaseString);
                            MuseRenderer.drawItemAt(-1.0, yBaseIcon, clock);
                            continue;
                        }
                        MuseRenderer.drawString(hour + ampm, 17.0, yBaseString + yOffsetString * i);
                        MuseRenderer.drawItemAt(-1.0, yBaseIcon + yOffsetIcon * (double)i, clock);
                        continue;
                    }
                    if (Objects.equals(this.modules.get(i), "Compass")) {
                        if (i == 0) {
                            MuseRenderer.drawItemAt(-1.0, yBaseIcon, compass);
                            continue;
                        }
                        MuseRenderer.drawItemAt(-1.0, yBaseIcon + yOffsetIcon * (double)i, compass);
                        continue;
                    }
                    if (!Objects.equals(this.modules.get(i), "Water Tank")) continue;
                    this.drawWaterMeter = true;
                }
                this.drawMeters((EntityPlayer)player, screen);
            }
        }
    }

    private void drawMeters(EntityPlayer player, ScaledResolution screen) {
        double left = screen.func_78326_a() - 30;
        double top = (double)screen.func_78328_b() / 2.0 - 16.0;
        double currHeat = MuseHeatUtils.getPlayerHeat(player);
        double maxHeat = MuseHeatUtils.getMaxHeat(player);
        String currHeatStr = MuseStringUtils.formatNumberShort(currHeat);
        String maxHeatStr = MuseStringUtils.formatNumberShort(maxHeat);
        if (Config.useGraphicalMeters()) {
            if (this.heat == null) {
                this.heat = new HeatMeter();
            }
            this.heat.draw(left + 8.0, top, currHeat / maxHeat);
            MuseRenderer.drawRightAlignedString(currHeatStr, left - 2.0, top + 20.0);
        } else {
            MuseRenderer.drawString(currHeatStr + '/' + maxHeatStr + " C", 1.0, 10.0);
        }
        double currWater = AddonWaterUtils.getPlayerWater(player);
        double maxWater = AddonWaterUtils.getMaxWater(player);
        double currEnergy = ElectricItemUtils.getPlayerEnergy(player);
        double maxEnergy = ElectricItemUtils.getMaxEnergy(player);
        if (maxEnergy > 0.0) {
            String currEnergyStr = MuseStringUtils.formatNumberShort(currEnergy);
            String maxEnergyStr = MuseStringUtils.formatNumberShort(maxEnergy);
            if (Config.useGraphicalMeters()) {
                if (this.energy == null) {
                    this.energy = new EnergyMeter();
                }
                this.energy.draw(left, top, currEnergy / maxEnergy);
                MuseRenderer.drawRightAlignedString(currEnergyStr, left - 2.0, top + 10.0);
            } else {
                MuseRenderer.drawString(currEnergyStr + '/' + maxEnergyStr + " \u1d60", 1.0, 1.0);
            }
        }
        if (maxWater > 0.0 && this.drawWaterMeter) {
            String currWaterStr = MuseStringUtils.formatNumberShort(currWater);
            String maxWaterStr = MuseStringUtils.formatNumberShort(maxWater);
            if (Config.useGraphicalMeters()) {
                if (this.water == null) {
                    this.water = new WaterMeter();
                }
                this.water.draw(left + 16.0, top, currWater / maxWater);
                MuseRenderer.drawRightAlignedString(currWaterStr, left - 2.0, top + 30.0);
            } else {
                MuseRenderer.drawString(currWaterStr + '/' + maxWaterStr + " buckets", 1.0, 19.0);
            }
        }
    }
}

