/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.tool;

import cpw.mods.fml.common.eventhandler.Event;
import java.util.List;
import net.machinemuse.api.IModularItem;
import net.machinemuse.api.IPowerModule;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.moduletrigger.IRightClickModule;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.utils.ElectricItemUtils;
import net.machinemuse.utils.MuseItemUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.UseHoeEvent;

public class HoeModule
extends PowerModuleBase
implements IPowerModule,
IRightClickModule {
    public static final String MODULE_HOE = "Rototiller";
    public static final String HOE_ENERGY_CONSUMPTION = "Hoe Energy Consumption";
    public static final String HOE_SEARCH_RADIUS = "Hoe Search Radius";

    public HoeModule(List<IModularItem> validItems) {
        super(validItems);
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.solenoid, 1));
        this.addBaseProperty(HOE_ENERGY_CONSUMPTION, 50.0);
        this.addTradeoffProperty("Search Radius", HOE_ENERGY_CONSUMPTION, 950.0);
        this.addTradeoffProperty("Search Radius", HOE_SEARCH_RADIUS, 8.0, "m");
    }

    @Override
    public void onRightClick(EntityPlayer playerClicking, World world, ItemStack item) {
    }

    @Override
    public boolean onItemUse(ItemStack itemStack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        double energyConsumed = ModuleManager.computeModularProperty(itemStack, HOE_ENERGY_CONSUMPTION);
        if (player.func_82247_a(x, y, z, side, itemStack) && ElectricItemUtils.getPlayerEnergy(player) > energyConsumed) {
            UseHoeEvent event = new UseHoeEvent(player, itemStack, world, x, y, z);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                return false;
            }
            if (event.getResult() == Event.Result.ALLOW) {
                ElectricItemUtils.drainPlayerEnergy(player, energyConsumed);
                return true;
            }
            if (world.field_72995_K) {
                return true;
            }
            boolean used = false;
            double radius = (int)ModuleManager.computeModularProperty(itemStack, HOE_SEARCH_RADIUS);
            int i = (int)Math.floor(-radius);
            while ((double)i < radius) {
                int j = (int)Math.floor(-radius);
                while ((double)j < radius) {
                    if ((double)(i * i + j * j) < radius * radius) {
                        int newX = x + i;
                        int newZ = z + j;
                        Block block = world.func_147439_a(newX, y, newZ);
                        if (side != 0 && world.func_147439_a(newX, y + 1, newZ).isAir((IBlockAccess)world, newX, y + 1, newZ) && (block == Blocks.field_150349_c || block == Blocks.field_150346_d)) {
                            world.func_147449_b(newX, y, newZ, Blocks.field_150458_ak);
                            ElectricItemUtils.drainPlayerEnergy(player, ModuleManager.computeModularProperty(itemStack, HOE_ENERGY_CONSUMPTION));
                            used = true;
                        }
                    }
                    ++j;
                }
                ++i;
            }
            if (used) {
                world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), Blocks.field_150458_ak.field_149762_H.func_150498_e(), (Blocks.field_150458_ak.field_149762_H.func_150497_c() + 1.0f) / 2.0f, Blocks.field_150458_ak.field_149762_H.func_150494_d() * 0.8f);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean onItemUseFirst(ItemStack itemStack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void onPlayerStoppedUsing(ItemStack itemStack, World world, EntityPlayer player, int par4) {
    }

    @Override
    public String getCategory() {
        return "Tool";
    }

    @Override
    public String getDataName() {
        return MODULE_HOE;
    }

    @Override
    public String getUnlocalizedName() {
        return "hoe";
    }

    @Override
    public String getDescription() {
        return "An automated tilling addon to make it easy to till large swaths of land at once.";
    }

    @Override
    public String getTextureFile() {
        return null;
    }

    @Override
    public IIcon getIcon(ItemStack item) {
        return ((Item)Item.field_150901_e.func_82594_a("golden_hoe")).func_77617_a(0);
    }
}

