/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex;

import cpw.mods.fml.common.event.FMLInterModComms;
import ivorius.ivtoolkit.tools.IvFMLIntercommHandler;
import ivorius.ivtoolkit.tools.IvNBTHelper;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.dimensions.DimensionDictionary;
import ivorius.reccomplex.files.FileLoadContext;
import ivorius.reccomplex.structures.generic.matchers.BiomeMatcher;
import ivorius.reccomplex.structures.generic.matchers.DimensionMatcher;
import ivorius.reccomplex.worldgen.StructureSelector;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.helpers.Strings;

public class RCCommunicationHandler
extends IvFMLIntercommHandler {
    public RCCommunicationHandler(Logger logger, String modOwnerID, Object modInstance) {
        super(logger, modOwnerID, modInstance);
    }

    protected boolean handleMessage(FMLInterModComms.IMCMessage message, boolean server, boolean runtime) {
        if (this.isMessage("loadFile", message, NBTTagCompound.class) || this.isMessage("loadInventoryGenerator", message, NBTTagCompound.class)) {
            NBTTagCompound cmp = message.getNBTValue();
            String genPath = cmp.func_74779_i("genPath");
            String genID = cmp.func_150297_b("genID", 8) ? cmp.func_74779_i("genID") : null;
            boolean generates = cmp.func_74767_n("generates");
            ResourceLocation resourceLocation = new ResourceLocation(genPath);
            RecurrentComplex.fileTypeRegistry.tryLoad(resourceLocation, new FileLoadContext(resourceLocation.func_110624_b(), generates, false, genID));
            return true;
        }
        if (this.isMessage("loadStructure", message, NBTTagCompound.class)) {
            NBTTagCompound cmp = message.getNBTValue();
            String structurePath = cmp.func_74779_i("structurePath");
            String structureID = cmp.func_74779_i("structureID");
            boolean generates = cmp.func_74767_n("generates");
            ResourceLocation resourceLocation = new ResourceLocation(structurePath);
            RecurrentComplex.fileTypeRegistry.tryLoad(resourceLocation, new FileLoadContext(resourceLocation.func_110624_b(), generates, false, structureID));
            return true;
        }
        if (this.isMessage("registerDimension", message, NBTTagCompound.class)) {
            NBTTagCompound cmp = message.getNBTValue();
            int dimensionID = cmp.func_74762_e("dimensionID");
            String[] types = IvNBTHelper.readNBTStrings((String)"types", (NBTTagCompound)cmp);
            if (types != null) {
                DimensionDictionary.registerDimensionTypes(dimensionID, Arrays.asList(types));
            } else {
                this.getLogger().warn("Could not handle message with key '" + message.key + "' - missing 'types' key!");
            }
            return true;
        }
        if (this.isMessage("unregisterDimension", message, NBTTagCompound.class)) {
            NBTTagCompound cmp = message.getNBTValue();
            int dimensionID = cmp.func_74762_e("dimensionID");
            String[] types = IvNBTHelper.readNBTStrings((String)"types", (NBTTagCompound)cmp);
            if (types != null) {
                DimensionDictionary.unregisterDimensionTypes(dimensionID, Arrays.asList(types));
            } else {
                DimensionDictionary.unregisterDimensionTypes(dimensionID, null);
            }
            return true;
        }
        if (this.isMessage("registerDimensionType", message, String.class)) {
            DimensionDictionary.registerType(message.getStringValue());
            return true;
        }
        if (this.isMessage("registerDimensionSubtypes", message, NBTTagCompound.class)) {
            NBTTagCompound cmp = message.getNBTValue();
            String type = cmp.func_74779_i("type");
            String[] subtypes = IvNBTHelper.readNBTStrings((String)"subtypes", (NBTTagCompound)cmp);
            if (!Strings.isEmpty((CharSequence)type)) {
                DimensionDictionary.registerSubtypes(type, Arrays.asList(subtypes));
            } else {
                this.getLogger().warn("Could not handle message with key '" + message.key + "' - missing 'subtypes' key!");
            }
            return true;
        }
        if (this.isMessage("registerDimensionSupertypes", message, NBTTagCompound.class)) {
            NBTTagCompound cmp = message.getNBTValue();
            String type = cmp.func_74779_i("type");
            String[] subtypes = IvNBTHelper.readNBTStrings((String)"supertypes", (NBTTagCompound)cmp);
            if (!Strings.isEmpty((CharSequence)type)) {
                DimensionDictionary.registerSupertypes(type, Arrays.asList(subtypes));
            } else {
                this.getLogger().warn("Could not handle message with key '" + message.key + "' - missing 'supertypes' key!");
            }
            return true;
        }
        if (this.isMessage("registerSimpleSpawnCategory", message, NBTTagCompound.class)) {
            NBTTagCompound cmp = message.getNBTValue();
            String id = cmp.func_74779_i("id");
            float defaultSpawnChance = cmp.func_74760_g("defaultSpawnChance");
            boolean selectableInGui = cmp.func_74767_n("selectableInGui");
            int structureMinCap = cmp.func_74762_e("structureMinCap");
            String[] biomeTypes = IvNBTHelper.readNBTStrings((String)"biomeTypes", (NBTTagCompound)cmp);
            if (!Strings.isEmpty((CharSequence)id)) {
                StructureSelector.GenerationInfo[] biomeInfos = new StructureSelector.GenerationInfo[biomeTypes.length];
                for (int i = 0; i < biomeTypes.length; ++i) {
                    String[] biomeParts = biomeTypes[i].split(":", 2);
                    biomeInfos[i] = new StructureSelector.GenerationInfo(Float.valueOf(biomeParts[0]).floatValue(), new BiomeMatcher(biomeParts[1]), new DimensionMatcher(""));
                }
                StructureSelector.registerCategory(id, new StructureSelector.SimpleCategory(defaultSpawnChance, Arrays.asList(biomeInfos), selectableInGui, structureMinCap), false);
            } else {
                this.getLogger().warn("Could not handle message with key '" + message.key + "' - missing 'id' key!");
            }
            return true;
        }
        if (this.isMessage("registerLegacyBlockIds", message, NBTTagCompound.class)) {
            NBTTagCompound cmp = message.getNBTValue();
            Block block = RecurrentComplex.specialRegistry.blockFromID(cmp.func_74779_i("block"));
            if (block != null) {
                boolean inferItem = cmp.func_74767_n("inferItem");
                String[] legacyIDs = IvNBTHelper.readNBTStrings((String)"legacyIDs", (NBTTagCompound)cmp);
                RecurrentComplex.cremapper.registerLegacyIDs(block, inferItem, legacyIDs);
            } else {
                this.getLogger().warn("Could not handle message with key '" + message.key + "' - could not find block!");
            }
        } else if (this.isMessage("registerLegacyItemIds", message, NBTTagCompound.class)) {
            NBTTagCompound cmp = message.getNBTValue();
            Item item = RecurrentComplex.specialRegistry.itemFromID(cmp.func_74779_i("item"));
            if (item != null) {
                String[] legacyIDs = IvNBTHelper.readNBTStrings((String)"legacyIDs", (NBTTagCompound)cmp);
                RecurrentComplex.cremapper.registerLegacyIDs(item, legacyIDs);
            } else {
                this.getLogger().warn("Could not handle message with key '" + message.key + "' - could not find item!");
            }
        }
        return false;
    }
}

