/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.commands;

import ivorius.ivtoolkit.tools.IvGsonHelper;
import ivorius.reccomplex.RCConfig;
import ivorius.reccomplex.json.RCGsonHelper;
import ivorius.reccomplex.structures.generic.matchers.BiomeMatcher;
import ivorius.reccomplex.utils.ServerTranslations;
import java.util.List;
import java.util.Set;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.event.ClickEvent;
import net.minecraft.event.HoverEvent;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import org.apache.commons.lang3.StringUtils;

public class CommandBiomeDict
extends CommandBase {
    public String func_71517_b() {
        return RCConfig.commandPrefix + "biomedict";
    }

    public int func_82362_a() {
        return 2;
    }

    public String func_71518_a(ICommandSender commandSender) {
        return ServerTranslations.usage("commands.biomedict.usage");
    }

    public void func_71515_b(ICommandSender commandSender, String[] args) {
        if (args.length < 2) {
            throw ServerTranslations.wrongUsageException("commands.biomedict.usage", new Object[0]);
        }
        switch (args[0]) {
            case "get": {
                Set<BiomeGenBase> biomes = BiomeMatcher.gatherAllBiomes();
                boolean didFindBiome = false;
                String biomeName = CommandBiomeDict.func_147178_a((ICommandSender)commandSender, (String[])args, (int)1).func_150260_c();
                for (BiomeGenBase biomeGenBase : biomes) {
                    if (!biomeGenBase.field_76791_y.equals(biomeName)) continue;
                    BiomeDictionary.Type[] types = BiomeDictionary.getTypesForBiome((BiomeGenBase)biomeGenBase);
                    Object[] components = new IChatComponent[types.length];
                    for (int i = 0; i < types.length; ++i) {
                        BiomeDictionary.Type type = types[i];
                        components[i] = new ChatComponentText(IvGsonHelper.serializedName((Enum)type));
                        components[i].func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format("/%s list %s", this.func_71517_b(), type)));
                        components[i].func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, ServerTranslations.format("commands.biomedict.get.number", BiomeDictionary.getBiomesForType((BiomeDictionary.Type)type).length)));
                    }
                    commandSender.func_145747_a(ServerTranslations.format("commands.biomedict.get", biomeName, new ChatComponentTranslation(StringUtils.repeat((String)"%s", (String)", ", (int)components.length), components)));
                    didFindBiome = true;
                    break;
                }
                if (didFindBiome) break;
                commandSender.func_145747_a(ServerTranslations.format("commands.biomedict.nobiome", biomeName));
                break;
            }
            case "list": {
                BiomeDictionary.Type type = (BiomeDictionary.Type)RCGsonHelper.enumForNameIgnoreCase((String)args[1], (Enum[])BiomeDictionary.Type.values());
                if (type != null) {
                    BiomeGenBase[] biomes = BiomeDictionary.getBiomesForType((BiomeDictionary.Type)type);
                    Object[] components = new IChatComponent[biomes.length];
                    for (int i = 0; i < biomes.length; ++i) {
                        BiomeGenBase biome = biomes[i];
                        components[i] = new ChatComponentText(biome.field_76791_y);
                        components[i].func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format("/%s get %s", this.func_71517_b(), biome.field_76791_y)));
                        components[i].func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, ServerTranslations.format("commands.biomedict.list.number", BiomeDictionary.getTypesForBiome((BiomeGenBase)biome).length)));
                    }
                    commandSender.func_145747_a(ServerTranslations.format("commands.biomedict.list", args[1], new ChatComponentTranslation(StringUtils.repeat((String)"%s", (String)", ", (int)components.length), components)));
                    break;
                }
                commandSender.func_145747_a(ServerTranslations.format("commands.biomedict.notype", args[1]));
                break;
            }
            default: {
                throw ServerTranslations.wrongUsageException("commands.biomedict.usage", new Object[0]);
            }
        }
    }

    public List func_71516_a(ICommandSender commandSender, String[] args) {
        if (args.length == 1) {
            return CommandBiomeDict.func_71530_a((String[])args, (String[])new String[]{"get", "list"});
        }
        if (args[0].equals("get")) {
            Set<BiomeGenBase> biomes = BiomeMatcher.gatherAllBiomes();
            String[] biomeNames = new String[biomes.size()];
            int index = 0;
            for (BiomeGenBase biome : biomes) {
                biomeNames[index++] = biome.field_76791_y;
            }
            return CommandBiomeDict.func_71530_a((String[])args, (String[])biomeNames);
        }
        if (args[0].equals("list")) {
            BiomeDictionary.Type[] types = BiomeDictionary.Type.values();
            String[] typeNames = new String[types.length];
            for (int i = 0; i < types.length; ++i) {
                typeNames[i] = IvGsonHelper.serializedName((Enum)types[i]);
            }
            return CommandBiomeDict.func_71530_a((String[])args, (String[])typeNames);
        }
        return null;
    }
}

