/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.commands;

import com.google.common.collect.Lists;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import ivorius.reccomplex.RCConfig;
import ivorius.reccomplex.dimensions.DimensionDictionary;
import ivorius.reccomplex.utils.ServerTranslations;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.event.ClickEvent;
import net.minecraft.event.HoverEvent;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.DimensionManager;
import org.apache.commons.lang3.StringUtils;

public class CommandDimensionDict
extends CommandBase {
    public String func_71517_b() {
        return RCConfig.commandPrefix + "dimensiondict";
    }

    public int func_82362_a() {
        return 2;
    }

    public String func_71518_a(ICommandSender commandSender) {
        return ServerTranslations.usage("commands.dimensiondict.usage");
    }

    public void func_71515_b(ICommandSender commandSender, String[] args) {
        if (args.length < 2) {
            throw ServerTranslations.wrongUsageException("commands.dimensiondict.usage", new Object[0]);
        }
        switch (args[0]) {
            case "get": {
                int dimensionID = CommandDimensionDict.func_71526_a((ICommandSender)commandSender, (String)args[1]);
                ArrayList types = Lists.newArrayList(DimensionDictionary.getDimensionTypes(DimensionManager.getProvider((int)dimensionID)));
                Object[] components = new IChatComponent[types.size()];
                for (int i = 0; i < components.length; ++i) {
                    String type = (String)types.get(i);
                    components[i] = new ChatComponentText(type);
                    components[i].func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format("/%s list %s", this.func_71517_b(), type)));
                    components[i].func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, ServerTranslations.format("commands.dimensiondict.get.number", this.allDimensionsOfType(type).size())));
                }
                commandSender.func_145747_a(ServerTranslations.format("commands.dimensiondict.get", dimensionID, new ChatComponentTranslation(StringUtils.repeat((String)"%s", (String)", ", (int)components.length), components)));
                break;
            }
            case "list": {
                String type = args[1];
                TIntList typeDimensions = this.allDimensionsOfType(type);
                Object[] components = new IChatComponent[typeDimensions.size()];
                for (int i = 0; i < components.length; ++i) {
                    int dimensionID = typeDimensions.get(i);
                    components[i] = new ChatComponentText(String.valueOf(dimensionID));
                    components[i].func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format("/%s get %s", this.func_71517_b(), dimensionID)));
                    components[i].func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, ServerTranslations.format("commands.dimensiondict.list.number", DimensionDictionary.getDimensionTypes(DimensionManager.getProvider((int)dimensionID)).size())));
                }
                commandSender.func_145747_a(ServerTranslations.format("commands.dimensiondict.list", type, new ChatComponentTranslation(StringUtils.repeat((String)"%s", (String)", ", (int)components.length), components)));
                break;
            }
            default: {
                throw ServerTranslations.wrongUsageException("commands.dimensiondict.usage", new Object[0]);
            }
        }
    }

    private TIntList allDimensionsOfType(String type) {
        TIntArrayList intList = new TIntArrayList();
        Integer[] integerArray = DimensionManager.getIDs();
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int d = integerArray[i];
            if (!DimensionDictionary.dimensionMatchesType(DimensionManager.getProvider((int)d), type)) continue;
            intList.add(d);
        }
        return intList;
    }

    public List func_71516_a(ICommandSender commandSender, String[] args) {
        if (args.length == 1) {
            return CommandDimensionDict.func_71530_a((String[])args, (String[])new String[]{"get", "list"});
        }
        if (args[0].equals("get")) {
            Integer[] dimensions = DimensionManager.getIDs();
            String[] dimensionStrings = new String[dimensions.length];
            for (int i = 0; i < dimensions.length; ++i) {
                dimensionStrings[i] = String.valueOf(dimensions[i]);
            }
            return CommandDimensionDict.func_71530_a((String[])args, (String[])dimensionStrings);
        }
        if (args[0].equals("list")) {
            return CommandDimensionDict.func_71531_a((String[])args, DimensionDictionary.allRegisteredTypes());
        }
        return null;
    }
}

