/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.commands;

import ivorius.ivtoolkit.blocks.BlockArea;
import ivorius.ivtoolkit.blocks.BlockCoord;
import ivorius.ivtoolkit.tools.IvWorldData;
import ivorius.reccomplex.RCConfig;
import ivorius.reccomplex.commands.RCCommands;
import ivorius.reccomplex.entities.StructureEntityInfo;
import ivorius.reccomplex.network.PacketEditStructureHandler;
import ivorius.reccomplex.structures.StructureInfo;
import ivorius.reccomplex.structures.StructureRegistry;
import ivorius.reccomplex.structures.generic.GenericStructureInfo;
import ivorius.reccomplex.utils.ServerTranslations;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;

public class CommandExportStructure
extends CommandBase {
    public String func_71517_b() {
        return RCConfig.commandPrefix + "export";
    }

    public int func_82362_a() {
        return 4;
    }

    public String func_71518_a(ICommandSender var1) {
        return ServerTranslations.usage("commands.strucExport.usage");
    }

    public void func_71515_b(ICommandSender commandSender, String[] args) {
        boolean saveAsActive;
        String structureID;
        GenericStructureInfo genericStructureInfo;
        EntityPlayerMP player = CommandExportStructure.func_71521_c((ICommandSender)commandSender);
        StructureEntityInfo structureEntityInfo = RCCommands.getStructureEntityInfo((Entity)player);
        if (!structureEntityInfo.hasValidSelection()) {
            throw ServerTranslations.wrongUsageException("commands.selectModify.noSelection", new Object[0]);
        }
        BlockArea area = new BlockArea(structureEntityInfo.selectedPoint1, structureEntityInfo.selectedPoint2);
        if (args.length >= 1) {
            genericStructureInfo = CommandExportStructure.getGenericStructureInfo(args[0]);
            structureID = args[0];
            saveAsActive = StructureRegistry.INSTANCE.isStructureGenerating(structureID);
        } else {
            genericStructureInfo = GenericStructureInfo.createDefaultStructure();
            structureID = "NewStructure";
            genericStructureInfo.metadata.authors = commandSender.func_70005_c_();
            saveAsActive = false;
        }
        BlockCoord lowerCoord = area.getLowerCorner();
        BlockCoord higherCoord = area.getHigherCorner();
        IvWorldData data = new IvWorldData(player.func_130014_f_(), new BlockArea(lowerCoord, higherCoord), true);
        genericStructureInfo.worldDataCompound = data.createTagCompound(lowerCoord);
        PacketEditStructureHandler.openEditStructure(genericStructureInfo, structureID, saveAsActive, player);
    }

    public List func_71516_a(ICommandSender commandSender, String[] args) {
        if (args.length == 1) {
            return CommandExportStructure.func_71531_a((String[])args, StructureRegistry.INSTANCE.allStructureIDs());
        }
        return null;
    }

    public static GenericStructureInfo getGenericStructureInfo(String name) {
        StructureInfo structureInfo = StructureRegistry.INSTANCE.getStructure(name);
        if (structureInfo == null) {
            throw ServerTranslations.commandException("commands.structure.notRegistered", name);
        }
        GenericStructureInfo genericStructureInfo = structureInfo.copyAsGenericStructureInfo();
        if (genericStructureInfo == null) {
            throw ServerTranslations.commandException("commands.structure.notGeneric", name);
        }
        return genericStructureInfo;
    }
}

