/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.commands;

import ivorius.ivtoolkit.blocks.BlockArea;
import ivorius.ivtoolkit.blocks.BlockAreas;
import ivorius.ivtoolkit.blocks.BlockCoord;
import ivorius.reccomplex.RCConfig;
import ivorius.reccomplex.blocks.RCBlocks;
import ivorius.reccomplex.commands.CommandSelectModify;
import ivorius.reccomplex.entities.StructureEntityInfo;
import ivorius.reccomplex.utils.ServerTranslations;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class CommandSelectSpace
extends CommandSelectModify {
    public static int sidesClosed(World world, BlockCoord coord, BlockArea area) {
        int sides = 0;
        BlockCoord lower = area.getLowerCorner();
        BlockCoord higher = area.getHigherCorner();
        if (CommandSelectSpace.sideClosed(world, new BlockCoord(lower.x, coord.y, coord.z), coord.x - lower.x, 1, 0, 0)) {
            ++sides;
        }
        if (CommandSelectSpace.sideClosed(world, new BlockCoord(higher.x, coord.y, coord.z), higher.x - coord.x, -1, 0, 0)) {
            ++sides;
        }
        if (CommandSelectSpace.sideClosed(world, new BlockCoord(coord.x, coord.y, lower.z), coord.z - lower.z, 0, 0, 1)) {
            ++sides;
        }
        if (CommandSelectSpace.sideClosed(world, new BlockCoord(coord.x, coord.y, higher.z), higher.z - coord.z, 0, 0, -1)) {
            ++sides;
        }
        return sides;
    }

    public static boolean sideClosed(World world, BlockCoord coord, int iterations, int xP, int yP, int zP) {
        for (int i = 0; i < iterations; ++i) {
            int x = coord.x + xP * i;
            int y = coord.y + yP * i;
            int z = coord.z + zP * i;
            Block block = world.func_147439_a(x, y, z);
            if (block.isReplaceable((IBlockAccess)world, x, y, z)) continue;
            return true;
        }
        return false;
    }

    public static void placeNaturalAir(World world, BlockArea area, int floorDistance, int maxClosedSides) {
        Block spaceBlock = RCBlocks.genericSpace;
        BlockCoord lowerPoint = area.getLowerCorner();
        BlockCoord higherPoint = area.getHigherCorner();
        for (BlockCoord surfaceCoord : BlockAreas.side((BlockArea)area, (ForgeDirection)ForgeDirection.DOWN)) {
            Block block;
            int y;
            int safePoint = lowerPoint.y;
            for (y = higherPoint.y; y >= lowerPoint.y; --y) {
                block = world.func_147439_a(surfaceCoord.x, y, surfaceCoord.z);
                if ((block.func_149688_o() == Material.field_151579_a || block == spaceBlock) && CommandSelectSpace.sidesClosed(world, new BlockCoord(surfaceCoord.x, y, surfaceCoord.z), area) < maxClosedSides) continue;
                safePoint = y + (block == RCBlocks.genericSolid ? 1 : floorDistance);
                break;
            }
            for (y = safePoint; y <= higherPoint.y; ++y) {
                world.func_147449_b(surfaceCoord.x, y, surfaceCoord.z, spaceBlock);
            }
            if (safePoint > lowerPoint.y) {
                for (y = lowerPoint.y; y <= higherPoint.y; ++y) {
                    block = world.func_147439_a(surfaceCoord.x, y, surfaceCoord.z);
                    if ((block.func_149688_o() == Material.field_151579_a || block == spaceBlock) && CommandSelectSpace.sidesClosed(world, new BlockCoord(surfaceCoord.x, y, surfaceCoord.z), area) < maxClosedSides) continue;
                    safePoint = y - 1;
                    break;
                }
            }
            for (y = lowerPoint.y; y <= safePoint; ++y) {
                world.func_147449_b(surfaceCoord.x, y, surfaceCoord.z, spaceBlock);
            }
        }
    }

    public String func_71517_b() {
        return RCConfig.commandPrefix + "space";
    }

    public String func_71518_a(ICommandSender var1) {
        return ServerTranslations.usage("commands.selectSpace.usage");
    }

    @Override
    public void processCommandSelection(EntityPlayerMP player, StructureEntityInfo structureEntityInfo, BlockCoord point1, BlockCoord point2, String[] args) {
        World world = player.func_130014_f_();
        BlockArea area = new BlockArea(point1, point2);
        int floorDistance = args.length >= 1 ? CommandSelectSpace.func_71526_a((ICommandSender)player, (String)args[0]) : 3;
        int maxClosedSides = args.length >= 2 ? CommandSelectSpace.func_71526_a((ICommandSender)player, (String)args[1]) : 3;
        CommandSelectSpace.placeNaturalAir(world, area, floorDistance, maxClosedSides);
    }

    public List func_71516_a(ICommandSender commandSender, String[] args) {
        if (args.length == 1) {
            return CommandSelectSpace.func_71530_a((String[])args, (String[])new String[]{"3", "2", "1"});
        }
        if (args.length == 2) {
            return CommandSelectSpace.func_71530_a((String[])args, (String[])new String[]{"3", "4", "5"});
        }
        return super.func_71516_a(commandSender, args);
    }
}

