/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.files;

import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.files.FileLoadContext;
import ivorius.reccomplex.files.FileSuffixFilter;
import ivorius.reccomplex.files.FileTypeHandler;
import ivorius.reccomplex.files.RCFileHelper;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.FilenameUtils;

public class FileTypeRegistry {
    private final Map<String, FileTypeHandler> handlers = new HashMap<String, FileTypeHandler>();

    public FileTypeHandler get(String suffix) {
        return this.handlers.get(suffix);
    }

    public FileTypeHandler put(String suffix, FileTypeHandler value) {
        return this.handlers.put(suffix, value);
    }

    public Set<String> keySet() {
        return this.handlers.keySet();
    }

    public void clearCustomFiles() {
        this.handlers.values().forEach(FileTypeHandler::clearCustomFiles);
    }

    public void clearCustomFiles(Collection<String> suffices) {
        this.handlers.entrySet().stream().filter(entry -> suffices.contains(entry.getKey())).forEach(entry -> ((FileTypeHandler)entry.getValue()).clearCustomFiles());
    }

    public int tryLoadAll(ResourceLocation resourceLocation, FileLoadContext context) {
        return this.tryLoadAll(resourceLocation, context, this.keySet());
    }

    public int tryLoadAll(ResourceLocation resourceLocation, FileLoadContext context, Collection<String> suffices) {
        try {
            Path path = RCFileHelper.pathFromResourceLocation(resourceLocation);
            if (path != null) {
                return this.tryLoadAll(path, context, suffices);
            }
        }
        catch (Throwable e) {
            RecurrentComplex.logger.error("Error reading from resource location '" + resourceLocation + "'", e);
        }
        return 0;
    }

    public int tryLoadAll(Path path, FileLoadContext context) {
        return this.tryLoadAll(path, context, this.keySet());
    }

    public int tryLoadAll(Path path, FileLoadContext context, Collection<String> suffices) {
        int added = 0;
        try {
            List<Path> paths = RCFileHelper.listFilesRecursively(path, new FileSuffixFilter(suffices), true);
            for (Path file : paths) {
                if (!this.tryLoad(file, context)) continue;
                ++added;
            }
            return added;
        }
        catch (IOException e) {
            RecurrentComplex.logger.error("Error loading resources from directory", (Throwable)e);
            return added;
        }
    }

    public boolean tryLoad(ResourceLocation resourceLocation, FileLoadContext context) {
        try {
            Path path = RCFileHelper.pathFromResourceLocation(resourceLocation);
            if (path != null) {
                return this.tryLoad(path, context);
            }
        }
        catch (Throwable e) {
            RecurrentComplex.logger.error("Error reading from resource location '" + resourceLocation + "'", e);
        }
        return false;
    }

    public boolean tryLoad(Path file, FileLoadContext context) {
        try {
            FileTypeHandler handler = this.get(FilenameUtils.getExtension((String)file.getFileName().toString()));
            return handler.loadFile(file, context);
        }
        catch (Exception e) {
            RecurrentComplex.logger.error("Error loading resource", (Throwable)e);
            return false;
        }
    }
}

