/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.files;

import ivorius.ivtoolkit.tools.IvFileHelper;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.files.FileLoadContext;
import ivorius.reccomplex.files.FileTypeRegistry;
import ivorius.reccomplex.files.RCFileHelper;
import java.io.File;
import java.util.Collection;
import net.minecraft.util.ResourceLocation;

public class RCFileTypeRegistry
extends FileTypeRegistry {
    public static final String ACTIVE_DIR_NAME = "active";
    public static final String INACTIVE_DIR_NAME = "inactive";

    public static String getStructuresDirectoryName(boolean activeFolder) {
        return activeFolder ? ACTIVE_DIR_NAME : INACTIVE_DIR_NAME;
    }

    public static File getBaseStructuresDirectory() {
        return RecurrentComplex.proxy.getBaseFolderFile("structures");
    }

    public static File getStructuresDirectory(boolean activeFolder) {
        return RCFileHelper.getValidatedFolder(RCFileTypeRegistry.getBaseStructuresDirectory(), RCFileTypeRegistry.getStructuresDirectoryName(activeFolder), true);
    }

    public void reloadCustomFiles() {
        this.reloadCustomFiles(this.keySet());
    }

    public void reloadCustomFiles(Collection<String> suffices) {
        this.clearCustomFiles(suffices);
        File structuresFile = IvFileHelper.getValidatedFolder((File)RCFileTypeRegistry.getBaseStructuresDirectory());
        if (structuresFile != null) {
            this.tryLoadAll(suffices, structuresFile, ACTIVE_DIR_NAME, true, "", true, true);
            this.tryLoadAll(suffices, structuresFile, INACTIVE_DIR_NAME, true, "", false, true);
            this.tryLoadAll(suffices, structuresFile, "genericStructures", false, "", true, true);
            this.tryLoadAll(suffices, structuresFile, "silentStructures", false, "", false, true);
            this.tryLoadAll(suffices, structuresFile, "inventoryGenerators", false, "", true, true);
        }
    }

    protected void tryLoadAll(Collection<String> suffices, File structuresFile, String activeDirName, boolean create, String domain, boolean active, boolean custom) {
        File validatedFolder = RCFileHelper.getValidatedFolder(structuresFile, activeDirName, create);
        if (validatedFolder != null) {
            this.tryLoadAll(validatedFolder.toPath(), new FileLoadContext(domain, active, custom), suffices);
        }
    }

    public void loadFilesFromMod(String modid) {
        this.loadFilesFromMod(modid, this.keySet());
    }

    public void loadFilesFromMod(String modid, Collection<String> suffices) {
        modid = modid.toLowerCase();
        this.tryLoadAll(new ResourceLocation(modid, "structures/active"), new FileLoadContext(modid, true, false));
        this.tryLoadAll(new ResourceLocation(modid, "structures/inactive"), new FileLoadContext(modid, false, false));
        this.tryLoadAll(new ResourceLocation(modid, "structures/genericStructures"), new FileLoadContext(modid, true, false));
        this.tryLoadAll(new ResourceLocation(modid, "structures/silentStructures"), new FileLoadContext(modid, false, false));
        this.tryLoadAll(new ResourceLocation(modid, "structures/inventoryGenerators"), new FileLoadContext(modid, true, false));
    }
}

