/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.editstructure;

import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.gui.table.TableCellButton;
import ivorius.reccomplex.gui.table.TableDataSource;
import ivorius.reccomplex.gui.table.TableDataSourceList;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.structures.StructureRegistry;
import ivorius.reccomplex.structures.generic.transformers.Transformer;
import ivorius.reccomplex.utils.IvTranslations;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.util.StatCollector;
import org.apache.commons.lang3.StringUtils;

public class TableDataSourceTransformerList
extends TableDataSourceList<Transformer, List<Transformer>> {
    public TableDataSourceTransformerList(List<Transformer> list, TableDelegate tableDelegate, TableNavigator navigator) {
        super(list, tableDelegate, navigator);
        this.setUsesPresetActionForAdding(true);
    }

    @Override
    public String getDisplayString(Transformer transformer) {
        return StringUtils.abbreviate((String)transformer.getDisplayString(), (int)24);
    }

    @Override
    public Transformer newEntry(String actionID) {
        Class<Transformer> clazz = StructureRegistry.INSTANCE.getTransformerRegistry().typeForID(actionID);
        return this.instantiateTransformer(clazz);
    }

    @Override
    public TableDataSource editEntryDataSource(Transformer entry) {
        return entry.tableDataSource(this.navigator, this.tableDelegate);
    }

    @Override
    public TableCellButton.Action[] getAddActions() {
        Collection<String> allTypes = StructureRegistry.INSTANCE.getTransformerRegistry().allIDs();
        ArrayList<TableCellButton.Action> actions = new ArrayList<TableCellButton.Action>(allTypes.size());
        for (String type : allTypes) {
            String baseKey = "reccomplex.transformer." + type;
            actions.add(new TableCellButton.Action(type, StatCollector.func_74838_a((String)baseKey), IvTranslations.formatLines(baseKey + ".tooltip", new Object[0])));
        }
        return actions.toArray(new TableCellButton.Action[actions.size()]);
    }

    public Transformer instantiateTransformer(Class<? extends Transformer> clazz) {
        Transformer transformer = null;
        try {
            transformer = clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            RecurrentComplex.logger.error((Object)e);
        }
        return transformer;
    }
}

