/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.editstructure.gentypes;

import com.google.common.primitives.Ints;
import ivorius.ivtoolkit.blocks.Directions;
import ivorius.reccomplex.gui.GuiValidityStateIndicator;
import ivorius.reccomplex.gui.TableDirections;
import ivorius.reccomplex.gui.editstructure.gentypes.TableDataSourceGenerationInfo;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.TableCellEnum;
import ivorius.reccomplex.gui.table.TableCellFloatNullable;
import ivorius.reccomplex.gui.table.TableCellPropertyDefault;
import ivorius.reccomplex.gui.table.TableCellPropertyListener;
import ivorius.reccomplex.gui.table.TableCellString;
import ivorius.reccomplex.gui.table.TableDataSourceSegmented;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableElement;
import ivorius.reccomplex.gui.table.TableElementCell;
import ivorius.reccomplex.gui.table.TableElements;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.structures.generic.gentypes.StructureListGenerationInfo;
import ivorius.reccomplex.utils.IvTranslations;
import ivorius.reccomplex.utils.scale.Scales;
import net.minecraftforge.common.util.ForgeDirection;

public class TableDataSourceStructureListGenerationInfo
extends TableDataSourceSegmented
implements TableCellPropertyListener {
    private TableNavigator navigator;
    private TableDelegate tableDelegate;
    private StructureListGenerationInfo generationInfo;

    public TableDataSourceStructureListGenerationInfo(TableNavigator navigator, TableDelegate tableDelegate, StructureListGenerationInfo generationInfo) {
        this.navigator = navigator;
        this.tableDelegate = tableDelegate;
        this.generationInfo = generationInfo;
        this.addManagedSection(0, new TableDataSourceGenerationInfo(generationInfo));
    }

    @Override
    public int numberOfSegments() {
        return 5;
    }

    @Override
    public int sizeOfSegment(int segment) {
        switch (segment) {
            case 1: {
                return 1;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 1;
            }
        }
        return super.sizeOfSegment(segment);
    }

    @Override
    public TableElement elementForIndexInSegment(GuiTable table, int index, int segment) {
        switch (segment) {
            case 1: {
                TableCellString cell = new TableCellString("listID", this.generationInfo.listID);
                cell.addPropertyListener(this);
                return new TableElementCell("List ID", cell);
            }
            case 2: {
                TableCellFloatNullable cell = new TableCellFloatNullable("weight", TableElements.toFloat(this.generationInfo.weight), 1.0f, 0.0f, 1000.0f, "D", "C");
                cell.setScale(Scales.pow(5.0f));
                cell.addPropertyListener(this);
                cell.setTooltip(IvTranslations.formatLines("structures.gui.random.weight.tooltip", new Object[0]));
                return new TableElementCell(IvTranslations.get("structures.gui.random.weight"), cell);
            }
            case 3: {
                if (index == 0) {
                    TableCellString cell = new TableCellString("positionX", String.valueOf(this.generationInfo.shiftX));
                    cell.setShowsValidityState(true);
                    cell.setValidityState(GuiValidityStateIndicator.State.VALID);
                    cell.addPropertyListener(this);
                    return new TableElementCell("Shift (x)", cell);
                }
                if (index == 1) {
                    TableCellString cell = new TableCellString("positionY", String.valueOf(this.generationInfo.shiftY));
                    cell.setShowsValidityState(true);
                    cell.setValidityState(GuiValidityStateIndicator.State.VALID);
                    cell.addPropertyListener(this);
                    return new TableElementCell("Shift (y)", cell);
                }
                if (index == 2) {
                    TableCellString cell = new TableCellString("positionZ", String.valueOf(this.generationInfo.shiftZ));
                    cell.setShowsValidityState(true);
                    cell.setValidityState(GuiValidityStateIndicator.State.VALID);
                    cell.addPropertyListener(this);
                    return new TableElementCell("Shift (z)", cell);
                }
            }
            case 4: {
                TableCellEnum<ForgeDirection> cell = new TableCellEnum<ForgeDirection>("front", this.generationInfo.front, TableDirections.getDirectionOptions(Directions.HORIZONTAL));
                cell.addPropertyListener(this);
                return new TableElementCell("Front", cell);
            }
        }
        return super.elementForIndexInSegment(table, index, segment);
    }

    @Override
    public void valueChanged(TableCellPropertyDefault cell) {
        if (cell.getID() != null) {
            switch (cell.getID()) {
                case "listID": {
                    this.generationInfo.listID = (String)cell.getPropertyValue();
                    break;
                }
                case "weight": {
                    this.generationInfo.weight = TableElements.toDouble((Float)cell.getPropertyValue());
                    break;
                }
                case "positionX": {
                    Integer val = Ints.tryParse((String)((String)cell.getPropertyValue()));
                    this.generationInfo.shiftX = val != null ? val : 0;
                    ((TableCellString)cell).setValidityState(val != null ? GuiValidityStateIndicator.State.VALID : GuiValidityStateIndicator.State.INVALID);
                    break;
                }
                case "positionY": {
                    Integer val = Ints.tryParse((String)((String)cell.getPropertyValue()));
                    this.generationInfo.shiftY = val != null ? val : 0;
                    ((TableCellString)cell).setValidityState(val != null ? GuiValidityStateIndicator.State.VALID : GuiValidityStateIndicator.State.INVALID);
                    break;
                }
                case "positionZ": {
                    Integer val = Ints.tryParse((String)((String)cell.getPropertyValue()));
                    this.generationInfo.shiftZ = val != null ? val : 0;
                    ((TableCellString)cell).setValidityState(val != null ? GuiValidityStateIndicator.State.VALID : GuiValidityStateIndicator.State.INVALID);
                    break;
                }
                case "front": {
                    this.generationInfo.front = (ForgeDirection)cell.getPropertyValue();
                }
            }
        }
    }
}

