/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.editstructure.transformers;

import ivorius.reccomplex.gui.GuiValidityStateIndicator;
import ivorius.reccomplex.gui.TableDataSourceExpression;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.TableCellFloatNullable;
import ivorius.reccomplex.gui.table.TableCellPropertyDefault;
import ivorius.reccomplex.gui.table.TableCellPropertyListener;
import ivorius.reccomplex.gui.table.TableCellString;
import ivorius.reccomplex.gui.table.TableDataSourceSegmented;
import ivorius.reccomplex.gui.table.TableElement;
import ivorius.reccomplex.gui.table.TableElementCell;
import ivorius.reccomplex.gui.table.TableElements;
import ivorius.reccomplex.structures.generic.transformers.TransformerNatural;
import ivorius.reccomplex.utils.IvTranslations;
import ivorius.reccomplex.utils.scale.Scales;
import net.minecraft.block.Block;

public class TableDataSourceBTNatural
extends TableDataSourceSegmented
implements TableCellPropertyListener {
    private TransformerNatural transformer;

    public TableDataSourceBTNatural(TransformerNatural transformer) {
        this.transformer = transformer;
        this.addManagedSection(0, TableDataSourceExpression.constructDefault("Sources", transformer.sourceMatcher));
    }

    public static TableCellString elementForBlock(String id, Block block) {
        TableCellString element = new TableCellString(id, Block.field_149771_c.func_148750_c((Object)block));
        element.setShowsValidityState(true);
        TableDataSourceBTNatural.setStateForBlockTextfield(element);
        return element;
    }

    public static void setStateForBlockTextfield(TableCellString elementString) {
        elementString.setValidityState(TableDataSourceBTNatural.stateForBlock((String)elementString.getPropertyValue()));
    }

    public static GuiValidityStateIndicator.State stateForBlock(String blockID) {
        return Block.field_149771_c.func_148741_d(blockID) ? GuiValidityStateIndicator.State.VALID : GuiValidityStateIndicator.State.INVALID;
    }

    public TransformerNatural getTransformer() {
        return this.transformer;
    }

    public void setTransformer(TransformerNatural transformer) {
        this.transformer = transformer;
    }

    @Override
    public int numberOfSegments() {
        return 2;
    }

    @Override
    public int sizeOfSegment(int segment) {
        return segment == 1 ? 2 : super.sizeOfSegment(segment);
    }

    @Override
    public TableElement elementForIndexInSegment(GuiTable table, int index, int segment) {
        if (segment == 1) {
            switch (index) {
                case 0: {
                    TableCellFloatNullable cell = new TableCellFloatNullable("naturalExpansionDistance", TableElements.toFloat(this.transformer.naturalExpansionDistance), 1.0f, 0.0f, 40.0f, "D", "C");
                    cell.setScale(Scales.pow(5.0f));
                    cell.addPropertyListener(this);
                    cell.setTooltip(IvTranslations.formatLines("reccomplex.transformer.natural.naturalExpansionDistance.tooltip", new Object[0]));
                    return new TableElementCell(IvTranslations.get("reccomplex.transformer.natural.naturalExpansionDistance"), cell);
                }
                case 1: {
                    TableCellFloatNullable cell = new TableCellFloatNullable("naturalExpansionRandomization", TableElements.toFloat(this.transformer.naturalExpansionRandomization), 1.0f, 0.0f, 40.0f, "D", "C");
                    cell.setScale(Scales.pow(5.0f));
                    cell.addPropertyListener(this);
                    cell.setTooltip(IvTranslations.formatLines("reccomplex.transformer.natural.naturalExpansionRandomization.tooltip", new Object[0]));
                    return new TableElementCell(IvTranslations.get("reccomplex.transformer.natural.naturalExpansionRandomization"), cell);
                }
            }
        }
        return super.elementForIndexInSegment(table, index, segment);
    }

    @Override
    public void valueChanged(TableCellPropertyDefault cell) {
        if (cell.getID() != null) {
            switch (cell.getID()) {
                case "naturalExpansionDistance": {
                    this.transformer.naturalExpansionDistance = TableElements.toDouble((Float)cell.getPropertyValue());
                    break;
                }
                case "naturalExpansionRandomization": {
                    this.transformer.naturalExpansionRandomization = TableElements.toDouble((Float)cell.getPropertyValue());
                }
            }
        }
    }
}

