/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.editstructure.transformers;

import ivorius.ivtoolkit.gui.FloatRange;
import ivorius.reccomplex.gui.TableDirections;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.TableCellEnum;
import ivorius.reccomplex.gui.table.TableCellFloat;
import ivorius.reccomplex.gui.table.TableCellFloatRange;
import ivorius.reccomplex.gui.table.TableCellPropertyDefault;
import ivorius.reccomplex.gui.table.TableCellPropertyListener;
import ivorius.reccomplex.gui.table.TableCellTitle;
import ivorius.reccomplex.gui.table.TableDataSourceSegmented;
import ivorius.reccomplex.gui.table.TableElement;
import ivorius.reccomplex.gui.table.TableElementCell;
import ivorius.reccomplex.structures.generic.transformers.TransformerRuins;
import ivorius.reccomplex.utils.IvTranslations;
import ivorius.reccomplex.utils.scale.Scales;
import net.minecraftforge.common.util.ForgeDirection;

public class TableDataSourceBTRuins
extends TableDataSourceSegmented
implements TableCellPropertyListener {
    private TransformerRuins transformer;

    public TableDataSourceBTRuins(TransformerRuins transformer) {
        this.transformer = transformer;
    }

    public TransformerRuins getTransformer() {
        return this.transformer;
    }

    public void setTransformer(TransformerRuins transformer) {
        this.transformer = transformer;
    }

    @Override
    public int numberOfSegments() {
        return 2;
    }

    @Override
    public int sizeOfSegment(int segment) {
        return segment == 0 ? 5 : 3;
    }

    @Override
    public TableElement elementForIndexInSegment(GuiTable table, int index, int segment) {
        switch (segment) {
            case 0: {
                switch (index) {
                    case 0: {
                        return new TableElementCell(new TableCellTitle("decayTitle", IvTranslations.get("reccomplex.transformer.ruins.decay.title")));
                    }
                    case 1: {
                        TableCellFloatRange cell = new TableCellFloatRange("decay", new FloatRange(this.transformer.minDecay, this.transformer.maxDecay), 0.0f, 1.0f, "%.2f");
                        cell.setScale(Scales.pow(5.0f));
                        cell.setTooltip(IvTranslations.formatLines("reccomplex.transformer.ruins.decay.base.tooltip", new Object[0]));
                        cell.addPropertyListener(this);
                        return new TableElementCell(IvTranslations.get("reccomplex.transformer.ruins.decay.base"), cell);
                    }
                    case 2: {
                        TableCellFloat cell = new TableCellFloat("decayChaos", this.transformer.decayChaos, 0.0f, 1.0f);
                        cell.setScale(Scales.pow(3.0f));
                        cell.setTooltip(IvTranslations.formatLines("reccomplex.transformer.ruins.decay.chaos.tooltip", new Object[0]));
                        cell.addPropertyListener(this);
                        return new TableElementCell(IvTranslations.get("reccomplex.transformer.ruins.decay.chaos"), cell);
                    }
                    case 3: {
                        TableCellFloat cell = new TableCellFloat("decayValueDensity", this.transformer.decayValueDensity, 0.0f, 1.0f);
                        cell.setScale(Scales.pow(3.0f));
                        cell.setTooltip(IvTranslations.formatLines("reccomplex.transformer.ruins.decay.density.tooltip", new Object[0]));
                        cell.addPropertyListener(this);
                        return new TableElementCell(IvTranslations.get("reccomplex.transformer.ruins.decay.density"), cell);
                    }
                    case 4: {
                        TableCellEnum<ForgeDirection> cell = new TableCellEnum<ForgeDirection>("decaySide", this.transformer.decayDirection, TableDirections.getDirectionOptions(ForgeDirection.VALID_DIRECTIONS));
                        cell.setTooltip(IvTranslations.formatLines("reccomplex.transformer.ruins.decay.direction.tooltip", new Object[0]));
                        cell.addPropertyListener(this);
                        return new TableElementCell(IvTranslations.get("reccomplex.transformer.ruins.decay.direction"), cell);
                    }
                }
                break;
            }
            case 1: {
                switch (index) {
                    case 0: {
                        return new TableElementCell(new TableCellTitle("otherTitle", IvTranslations.get("reccomplex.transformer.ruins.other.title")));
                    }
                    case 1: {
                        TableCellFloat cell = new TableCellFloat("erosion", this.transformer.blockErosion, 0.0f, 1.0f);
                        cell.setScale(Scales.pow(3.0f));
                        cell.setTooltip(IvTranslations.formatLines("reccomplex.transformer.ruins.erosion.tooltip", new Object[0]));
                        cell.addPropertyListener(this);
                        return new TableElementCell(IvTranslations.get("reccomplex.transformer.ruins.erosion"), cell);
                    }
                    case 2: {
                        TableCellFloat cell = new TableCellFloat("vines", this.transformer.vineGrowth, 0.0f, 1.0f);
                        cell.setScale(Scales.pow(3.0f));
                        cell.setTooltip(IvTranslations.formatLines("reccomplex.transformer.ruins.vines.tooltip", new Object[0]));
                        cell.addPropertyListener(this);
                        return new TableElementCell(IvTranslations.get("reccomplex.transformer.ruins.vines"), cell);
                    }
                }
            }
        }
        return null;
    }

    @Override
    public void valueChanged(TableCellPropertyDefault cell) {
        if (cell.getID() != null) {
            switch (cell.getID()) {
                case "decaySide": {
                    this.transformer.decayDirection = (ForgeDirection)cell.getPropertyValue();
                    break;
                }
                case "decay": {
                    FloatRange range = (FloatRange)cell.getPropertyValue();
                    this.transformer.minDecay = range.getMin();
                    this.transformer.maxDecay = range.getMax();
                    break;
                }
                case "decayChaos": {
                    this.transformer.decayChaos = ((Float)cell.getPropertyValue()).floatValue();
                    break;
                }
                case "decayValueDensity": {
                    this.transformer.decayValueDensity = ((Float)cell.getPropertyValue()).floatValue();
                    break;
                }
                case "erosion": {
                    this.transformer.blockErosion = ((Float)cell.getPropertyValue()).floatValue();
                    break;
                }
                case "vines": {
                    this.transformer.vineGrowth = ((Float)cell.getPropertyValue()).floatValue();
                }
            }
        }
    }
}

