/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.table;

import ivorius.ivtoolkit.gui.FloatRange;
import ivorius.ivtoolkit.gui.GuiControlListener;
import ivorius.ivtoolkit.gui.GuiSliderMultivalue;
import ivorius.ivtoolkit.gui.GuiSliderRange;
import ivorius.reccomplex.gui.table.Bounds;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.TableCellPropertyDefault;
import ivorius.reccomplex.utils.scale.Scale;
import ivorius.reccomplex.utils.scale.Scales;
import net.minecraft.client.gui.GuiButton;

public class TableCellFloatRange
extends TableCellPropertyDefault<FloatRange>
implements GuiControlListener<GuiSliderMultivalue> {
    protected GuiSliderRange slider;
    protected boolean enabled = true;
    protected float min;
    protected float max;
    protected Scale scale = Scales.none();
    protected String titleFormat = "%.4f";

    public TableCellFloatRange(String id, FloatRange value, float min, float max, String titleFormat) {
        super(id, value);
        this.min = min;
        this.max = max;
        this.titleFormat = titleFormat;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.slider != null) {
            this.slider.field_146124_l = enabled;
        }
    }

    public float getMin() {
        return this.min;
    }

    public void setMin(float min) {
        this.min = min;
    }

    public float getMax() {
        return this.max;
    }

    public void setMax(float max) {
        this.max = max;
    }

    public Scale getScale() {
        return this.scale;
    }

    public void setScale(Scale scale) {
        this.scale = scale;
    }

    public String getTitleFormat() {
        return this.titleFormat;
    }

    public void setTitleFormat(String titleFormat) {
        this.titleFormat = titleFormat;
    }

    @Override
    public void initGui(GuiTable screen) {
        super.initGui(screen);
        Bounds bounds = this.bounds();
        this.slider = new GuiSliderRange(-1, bounds.getMinX(), bounds.getMinY() + (bounds.getHeight() - 20) / 2, bounds.getWidth(), 20, this.getRangeString());
        this.slider.setMinValue(this.scale.out(this.min));
        this.slider.setMaxValue(this.scale.out(this.max));
        this.slider.field_146124_l = this.enabled;
        this.slider.addListener((GuiControlListener)this);
        this.slider.setRange(Scales.out(this.scale, (FloatRange)this.property));
        this.slider.field_146125_m = !this.isHidden();
        screen.addButton(this, 0, (GuiButton)this.slider);
    }

    @Override
    public void setHidden(boolean hidden) {
        super.setHidden(hidden);
        if (this.slider != null) {
            this.slider.field_146125_m = !hidden;
        }
    }

    public void valueChanged(GuiSliderMultivalue gui) {
        this.property = Scales.in(this.scale, ((GuiSliderRange)gui).getRange());
        this.slider.field_146126_j = this.getRangeString();
        this.alertListenersOfChange();
    }

    @Override
    public void setPropertyValue(FloatRange value) {
        super.setPropertyValue(value);
        if (this.slider != null) {
            this.slider.setRange(Scales.out(this.scale, (FloatRange)this.property));
            this.slider.field_146126_j = this.getRangeString();
        }
    }

    private String getRangeString() {
        return String.format(this.titleFormat, Float.valueOf(((FloatRange)this.property).getMin())) + " - " + String.format(this.titleFormat, Float.valueOf(((FloatRange)this.property).getMax()));
    }
}

