/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.table;

import ivorius.reccomplex.gui.table.Bounds;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.TableCell;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TableCellMulti
implements TableCell {
    @Nullable
    protected String id;
    private Bounds bounds = new Bounds(0, 0, 0, 0);
    protected boolean hidden;
    @Nonnull
    protected TableCell[] cells;

    public TableCellMulti(String id, TableCell ... cells) {
        this.id = id;
        this.cells = cells;
    }

    public TableCellMulti(TableCell ... cells) {
        this((String)null, cells);
    }

    @Override
    @Nullable
    public String getID() {
        return this.id;
    }

    public void setId(@Nonnull String id) {
        this.id = id;
    }

    @Nonnull
    public TableCell[] getCells() {
        return this.cells;
    }

    public void setCells(@Nonnull TableCell[] cells) {
        this.cells = cells;
    }

    @Override
    public void initGui(GuiTable screen) {
        for (TableCell cell : this.cells) {
            cell.initGui(screen);
        }
    }

    @Override
    public void setBounds(Bounds bounds) {
        int buttonWidth = bounds.getWidth() / this.cells.length;
        for (int i = 0; i < this.cells.length; ++i) {
            TableCell cell = this.cells[i];
            int realWidth = buttonWidth - (i == this.cells.length - 1 ? 0 : 2);
            cell.setBounds(Bounds.fromSize(bounds.getMinX() + buttonWidth * i, realWidth, bounds.getMinY(), bounds.getHeight()));
        }
    }

    @Override
    public Bounds bounds() {
        return this.bounds;
    }

    @Override
    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public void draw(GuiTable screen, int mouseX, int mouseY, float partialTicks) {
        for (TableCell cell : this.cells) {
            if (cell.isHidden()) continue;
            cell.draw(screen, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    public void drawFloating(GuiTable screen, int mouseX, int mouseY, float partialTicks) {
        for (TableCell cell : this.cells) {
            if (cell.isHidden()) continue;
            cell.drawFloating(screen, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    public void update(GuiTable screen) {
        for (TableCell cell : this.cells) {
            cell.update(screen);
        }
    }

    @Override
    public boolean keyTyped(char keyChar, int keyCode) {
        for (TableCell cell : this.cells) {
            if (!cell.keyTyped(keyChar, keyCode)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void mouseClicked(int button, int x, int y) {
        for (TableCell cell : this.cells) {
            cell.mouseClicked(button, x, y);
        }
    }

    @Override
    public void buttonClicked(int buttonID) {
        for (TableCell cell : this.cells) {
            cell.buttonClicked(buttonID);
        }
    }
}

