/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.table;

import ivorius.reccomplex.gui.table.TableCellDefault;
import ivorius.reccomplex.gui.table.TableCellProperty;
import ivorius.reccomplex.gui.table.TableCellPropertyListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class TableCellPropertyDefault<P>
extends TableCellDefault
implements TableCellProperty<P> {
    protected P property;
    private List<TableCellPropertyListener> listeners = new ArrayList<TableCellPropertyListener>();

    public TableCellPropertyDefault(String id, P value) {
        super(id);
        this.setPropertyValue(value);
    }

    public void addPropertyListener(TableCellPropertyListener listener) {
        this.listeners.add(listener);
    }

    public void removePropertyListener(TableCellPropertyListener listener) {
        this.listeners.remove(listener);
    }

    public List<TableCellPropertyListener> getListeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    protected void alertListenersOfChange() {
        for (TableCellPropertyListener listener : this.listeners) {
            listener.valueChanged(this);
        }
    }

    @Override
    public P getPropertyValue() {
        return this.property;
    }

    @Override
    public void setPropertyValue(P value) {
        this.property = value;
    }
}

