/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.table;

import ivorius.reccomplex.gui.GuiValidityStateIndicator;
import ivorius.reccomplex.gui.table.Bounds;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.TableCellPropertyDefault;
import net.minecraft.client.gui.GuiTextField;

public class TableCellString
extends TableCellPropertyDefault<String> {
    protected GuiTextField textField;
    protected GuiValidityStateIndicator stateIndicator;
    protected boolean showsValidityState;
    protected GuiValidityStateIndicator.State validityState;
    protected int maxStringLength = 300;

    public TableCellString(String id, String value) {
        super(id, value);
    }

    public int getMaxStringLength() {
        return this.maxStringLength;
    }

    public void setMaxStringLength(int maxStringLength) {
        this.maxStringLength = maxStringLength;
        if (this.textField != null) {
            this.textField.func_146203_f(maxStringLength);
        }
    }

    @Override
    public void initGui(GuiTable screen) {
        super.initGui(screen);
        Bounds bounds = this.bounds();
        this.textField = new GuiTextField(this.getFontRenderer(), bounds.getMinX(), bounds.getMinY() + (bounds.getHeight() - 20) / 2, bounds.getWidth() - (this.showsValidityState ? 15 : 0), 20);
        this.textField.func_146203_f(this.maxStringLength);
        this.textField.func_146180_a((String)this.getPropertyValue());
        this.textField.func_146189_e(!this.isHidden());
        if (this.showsValidityState) {
            this.stateIndicator = new GuiValidityStateIndicator(bounds.getMinX() + bounds.getWidth() - 10, bounds.getMinY() + (bounds.getHeight() - 10) / 2, this.validityState);
            this.stateIndicator.setVisible(!this.isHidden());
        } else {
            this.stateIndicator = null;
        }
    }

    @Override
    public void draw(GuiTable screen, int mouseX, int mouseY, float partialTicks) {
        super.draw(screen, mouseX, mouseY, partialTicks);
        this.textField.func_146194_f();
        if (this.stateIndicator != null) {
            this.stateIndicator.draw();
        }
    }

    @Override
    public void update(GuiTable screen) {
        super.update(screen);
        this.textField.func_146178_a();
    }

    @Override
    public boolean keyTyped(char keyChar, int keyCode) {
        super.keyTyped(keyChar, keyCode);
        String text = this.textField.func_146179_b();
        boolean used = this.textField.func_146201_a(keyChar, keyCode);
        this.property = this.textField.func_146179_b();
        if (!text.equals(this.property)) {
            this.alertListenersOfChange();
        }
        return used;
    }

    @Override
    public void mouseClicked(int button, int x, int y) {
        super.mouseClicked(button, x, y);
        this.textField.func_146192_a(x, y, button);
    }

    @Override
    public void setHidden(boolean hidden) {
        super.setHidden(hidden);
        if (this.textField != null) {
            this.textField.func_146189_e(!hidden);
        }
        if (this.stateIndicator != null) {
            this.stateIndicator.setVisible(!hidden);
        }
    }

    @Override
    public void setPropertyValue(String value) {
        super.setPropertyValue(value);
        if (this.textField != null) {
            this.textField.func_146180_a(value);
        }
    }

    public GuiValidityStateIndicator.State getValidityState() {
        return this.validityState;
    }

    public void setValidityState(GuiValidityStateIndicator.State validityState) {
        this.validityState = validityState;
        if (this.stateIndicator != null) {
            this.stateIndicator.setState(validityState);
        }
    }

    public boolean showsValidityState() {
        return this.showsValidityState;
    }

    public void setShowsValidityState(boolean showsValidityState) {
        this.showsValidityState = showsValidityState;
    }
}

