/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.table;

import ivorius.reccomplex.gui.table.Bounds;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.TableCellDefault;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.FontRenderer;

public class TableCellTitle
extends TableCellDefault {
    protected String displayString;
    @Nonnull
    protected Positioning positioning = Positioning.CENTER;

    public TableCellTitle(String id, String displayString) {
        super(id);
        this.displayString = displayString;
    }

    public String getDisplayString() {
        return this.displayString;
    }

    public void setDisplayString(String displayString) {
        this.displayString = displayString;
    }

    @Nonnull
    public Positioning getPositioning() {
        return this.positioning;
    }

    public void setPositioning(@Nonnull Positioning positioning) {
        this.positioning = positioning;
    }

    @Override
    public void draw(GuiTable screen, int mouseX, int mouseY, float partialTicks) {
        super.draw(screen, mouseX, mouseY, partialTicks);
        Bounds bounds = this.bounds();
        FontRenderer fontRenderer = this.getFontRenderer();
        screen.func_73732_a(fontRenderer, this.displayString, bounds.getCenterX(), this.positioning.getY(fontRenderer, bounds.getMinY(), bounds.getMaxY()), -1);
    }

    public static enum Positioning {
        BOTTOM,
        CENTER,
        TOP;


        public int getY(FontRenderer renderer, int min, int max) {
            switch (this) {
                case TOP: {
                    return min + 3;
                }
                case CENTER: {
                    return (min + max - renderer.field_78288_b) / 2;
                }
                case BOTTOM: {
                    return max - 2 - renderer.field_78288_b;
                }
            }
            throw new InternalError();
        }
    }
}

